/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent;

import java.io.IOException;
import opennlp.tools.ml.AbstractEventTrainer;
import opennlp.tools.ml.maxent.GISModel;
import opennlp.tools.ml.maxent.GISTrainer;
import opennlp.tools.ml.model.ChiSquaredDataIndexer;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.OnePassDataIndexer;
import opennlp.tools.ml.model.Prior;
import opennlp.tools.ml.model.TwoPassDataIndexer;
import opennlp.tools.ml.model.UniformPrior;
import opennlp.tools.util.ObjectStream;

public class AgeClassifyGIS
extends AbstractEventTrainer {
    public static final String MAXENT_VALUE = "AUTHORAGE";
    public static final String DATA_INDEXER_CHI_SQUARED = "ChiSquared";
    public static boolean PRINT_MESSAGES = true;
    public static double SMOOTHING_OBSERVATION = 0.1;

    public boolean isValid() {
        String dataIndexer = this.getStringParam("DataIndexer", "TwoPass");
        if (!(dataIndexer == null || "OnePass".equals(dataIndexer) || "TwoPass".equals(dataIndexer) || DATA_INDEXER_CHI_SQUARED.equals(dataIndexer))) {
            return false;
        }
        String algorithmName = this.getAlgorithm();
        return algorithmName == null || MAXENT_VALUE.equals(algorithmName);
    }

    public boolean isSortAndMerge() {
        return true;
    }

    public DataIndexer getDataIndexer(ObjectStream<Event> events) throws IOException {
        String dataIndexerName = this.getStringParam("DataIndexer", "TwoPass");
        int cutoff = this.getCutoff();
        boolean sortAndMerge = this.isSortAndMerge();
        Object indexer = null;
        if ("OnePass".equals(dataIndexerName)) {
            indexer = new OnePassDataIndexer(events, cutoff, sortAndMerge);
        } else if ("TwoPass".equals(dataIndexerName)) {
            indexer = new TwoPassDataIndexer(events, cutoff, sortAndMerge);
        } else if (DATA_INDEXER_CHI_SQUARED.equals(dataIndexerName)) {
            indexer = new ChiSquaredDataIndexer(events, cutoff, sortAndMerge);
        } else {
            throw new IllegalStateException("Unexpected data indexer name: " + dataIndexerName);
        }
        return indexer;
    }

    public MaxentModel doTrain(DataIndexer indexer) throws IOException {
        int iterations = this.getIterations();
        int threads = this.getIntParam("Threads", 1);
        GISModel model = AgeClassifyGIS.trainModel(iterations, indexer, true, false, null, 0, threads);
        return model;
    }

    public static GISModel trainModel(int iterations, DataIndexer indexer, boolean printMessagesWhileTraining, boolean smoothing, Prior modelPrior, int cutoff, int threads) {
        GISTrainer trainer = new GISTrainer(printMessagesWhileTraining);
        trainer.setSmoothing(smoothing);
        trainer.setSmoothingObservation(SMOOTHING_OBSERVATION);
        if (modelPrior == null) {
            modelPrior = new UniformPrior();
        }
        return trainer.trainModel(iterations, indexer, modelPrior, cutoff, threads);
    }
}

