/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.featuregen.FeatureGenerator;
import org.apache.commons.io.FileUtils;

public class LIWCFeatureGenerator
implements FeatureGenerator {
    public static final LIWCFeatureGenerator INSTANCE = new LIWCFeatureGenerator();
    private static Map<String, List<String>> liwc = new HashMap<String, List<String>>();

    @Override
    public Collection<String> extractFeatures(String[] text) {
        ArrayList<String> liwc_features = new ArrayList<String>();
        for (String word : text) {
            for (Map.Entry<String, List<String>> pair : liwc.entrySet()) {
                if (!pair.getValue().contains(word)) continue;
                liwc_features.add("liwc=" + pair.getKey());
            }
        }
        return liwc_features;
    }

    static {
        File[] files = new File("props/wordlists/").listFiles();
        if (files != null) {
            for (File file : files) {
                String filename = file.getName();
                filename = filename.substring(0, filename.lastIndexOf(46));
                try {
                    List list = FileUtils.readLines((File)file, (String)"utf-8");
                    liwc.put(filename, list);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

