/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.featuregen.FeatureGenerator;

public class POSFeatureGenerator
implements FeatureGenerator {
    public static final POSFeatureGenerator INSTANCE = new POSFeatureGenerator();
    private final String MODEL_FILE = "model/opennlp/en-pos-maxent.bin";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> extractFeatures(String[] text) {
        FileInputStream modelIn = null;
        ArrayList<String> pos = new ArrayList<String>();
        try {
            modelIn = new FileInputStream("model/opennlp/en-pos-maxent.bin");
            POSModel model = new POSModel((InputStream)modelIn);
            POSTaggerME tagger = new POSTaggerME(model);
            ArrayList<String> sentence = new ArrayList<String>();
            for (String token : text) {
                if (token == "<SENTENCE>") {
                    String[] tags = tagger.tag(sentence.toArray(new String[sentence.size()]));
                    for (int i = 0; i < tags.length; ++i) {
                        pos.add("pos=" + tags[i]);
                        if (i >= tags.length - 1) continue;
                        pos.add("posng=" + tags[i] + ":" + tags[i + 1]);
                    }
                    sentence.clear();
                    continue;
                }
                sentence.add(token);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    ((InputStream)modelIn).close();
                }
                catch (IOException iOException) {}
            }
        }
        return pos;
    }
}

