/*
 * Decompiled with CFR 0.152.
 */
package eu.bitwalker.useragentutils.browser;

import eu.bitwalker.useragentutils.Version;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SafariUtils {
    private static final String[][] webKitToSafariVersion = new String[][]{{"48", "0.8"}, {"73", "0.9"}, {"85", "1.0"}, {"85.8.5", "1.0.3"}, {"100", "1.1"}, {"125", "1.2"}, {"312", "1.3"}, {"312.3", "1.3.1"}, {"312.5", "1.3.2"}, {"312.6", "1.3.2"}, {"412", "2.0"}, {"416.11", "2.0.2"}, {"419.3", "2.0.4"}, {"522.11", "3.0"}, {"522.12", "3.0.2"}, {"522.12.1", "3.0.3"}, {"523.10", "3.0.4"}, {"525.20", "3.1.1"}, {"525.21", "3.1.2"}, {"525.26", "3.2"}, {"525.27", "3.2.1"}, {"525.28", "3.2.3"}, {"530.18", "4.0.1"}, {"530.19", "4.0.2"}, {"531.9", "4.0.3"}, {"531.21.10", "4.0.4"}, {"531.22.7", "4.0.5"}, {"533.20.27", "5.0.4"}, {"533.21.1", "5.0.5"}, {"533.22.3", "5.0.6"}, {"534.48.3", "5.1"}, {"534.51.22", "5.1.1"}, {"534.52.7", "5.1.2"}, {"534.53.10", "5.1.3"}, {"534.54.16", "5.1.4"}, {"534.55.3", "5.1.5"}, {"534.56.5", "5.1.6"}, {"534.57.2", "5.1.7"}, {"534.58.2", "5.1.8"}, {"534.59.8", "5.1.9"}, {"534.59.10", "5.1.10"}, {"536.25", "6.0"}, {"536.26", "6.0.1"}, {"536.26.17", "6.0.2"}, {"536.28.10", "6.0.3"}, {"536.29.13", "6.0.4"}, {"536.30.1", "6.0.5"}, {"537.43.58", "6.1"}, {"537.71", "7.0"}, {"537.75.14", "7.0.3"}, {"537.76.4", "7.0.4"}, {"537.77.4", "7.0.5"}, {"538.35.8", "8.0"}, {"600.6.3", "8.0.6"}, {"600.7.12", "8.0.7"}, {"601.2.7", "9.0.1"}, {"601.3.9", "9.0.2"}, {"601.4.4", "9.0.3"}, {"601.5.17", "9.1"}, {"601.6.17", "9.1.1"}, {"601.7.1", "9.1.2"}, {"601.7.8", "9.1.3"}, {"602.1.50", "10"}, {"602.2.14", "10.0.1"}, {"602.3.12", "10.0.2"}, {"602.4.8", "10.0.3"}, {"603.1.30", "10.1"}, {"603.2.4", "10.1.1"}, {"603.3.8", "10.1.2"}, {"522.11.3", "3.0"}, {"522.13.1", "3.0.2"}, {"522.12.2", "3.0.1"}, {"522.15.5", "3.0.3"}, {"523.12.9", "3.0.4"}, {"523.13", "3.0.4"}, {"523.15", "3.0.4"}, {"525.13", "3.1"}, {"525.17", "3.1.1"}, {"525.21", "3.1.2"}, {"525.26.13", "3.2"}, {"525.27.1", "3.2.1"}, {"525.28.1", "3.2.2"}, {"525.29.1", "3.2.3"}, {"526.12.2", "4.0"}, {"528.1.1", "4.0"}, {"526.11.2", "4.0"}, {"528.16", "4.0"}, {"528.17", "4.0"}, {"530.19.1", "4.0.2"}, {"531.9.1", "4.0.3"}, {"531.22.7", "4.0.5"}, {"534.50", "5.1"}};
    private static final Map<String, Version> safariVersions;

    public static Map<String, Version> getWebKitToSafariVersion() {
        return safariVersions;
    }

    static {
        HashMap<String, Version> versions = new HashMap<String, Version>();
        for (String[] pair : webKitToSafariVersion) {
            String webKitVersion = pair[0];
            String browserVersion = pair[1];
            String[] parts = browserVersion.split("\\.");
            String majorVersion = parts[0];
            String minorVersion = parts.length > 1 ? parts[1] : null;
            Version version = new Version(browserVersion, majorVersion, minorVersion);
            versions.put(webKitVersion, version);
        }
        safariVersions = Collections.unmodifiableMap(versions);
    }
}

