/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.context.internal;

import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.MavenSystemHome;
import java.nio.file.Path;
import java.util.Objects;

public final class MavenSystemHomeImpl
implements MavenSystemHome {
    private final Path mavenSystemHome;
    private final Path settingsXmlOverride;
    private final Path toolchainsXmlOverride;

    public MavenSystemHomeImpl(Path mavenSystemHome) {
        this(mavenSystemHome, null, null);
    }

    public MavenSystemHomeImpl(Path mavenSystemHome, Path settingsXmlOverride, Path toolchainsXmlOverride) {
        this.mavenSystemHome = Objects.requireNonNull(mavenSystemHome);
        this.settingsXmlOverride = settingsXmlOverride;
        this.toolchainsXmlOverride = toolchainsXmlOverride;
    }

    @Override
    public MavenSystemHomeImpl derive(ContextOverrides contextOverrides) {
        return new MavenSystemHomeImpl(contextOverrides.getMavenSystemHomeOverride() != null ? contextOverrides.getMavenSystemHomeOverride() : this.mavenSystemHome, contextOverrides.getGlobalSettingsXmlOverride() != null ? contextOverrides.getGlobalSettingsXmlOverride() : this.settingsXmlOverride, contextOverrides.getGlobalToolchainsXmlOverride() != null ? contextOverrides.getGlobalToolchainsXmlOverride() : this.toolchainsXmlOverride);
    }

    @Override
    public Path basedir() {
        return this.mavenSystemHome;
    }

    @Override
    public Path bin() {
        return this.basedir().resolve("bin");
    }

    @Override
    public Path boot() {
        return this.basedir().resolve("boot");
    }

    @Override
    public Path conf() {
        return this.basedir().resolve("conf");
    }

    @Override
    public Path lib() {
        return this.basedir().resolve("lib");
    }

    @Override
    public Path libExt() {
        return this.lib().resolve("ext");
    }

    @Override
    public Path settingsXml() {
        if (this.settingsXmlOverride != null) {
            return this.settingsXmlOverride;
        }
        return this.conf().resolve("settings.xml");
    }

    @Override
    public Path toolchainsXml() {
        if (this.toolchainsXmlOverride != null) {
            return this.toolchainsXmlOverride;
        }
        return this.conf().resolve("toolchains.xml");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenSystemHomeImpl that = (MavenSystemHomeImpl)o;
        return Objects.equals(this.mavenSystemHome, that.mavenSystemHome) && Objects.equals(this.settingsXmlOverride, that.settingsXmlOverride) && Objects.equals(this.toolchainsXmlOverride, that.toolchainsXmlOverride);
    }

    public int hashCode() {
        return Objects.hash(this.mavenSystemHome, this.settingsXmlOverride, this.toolchainsXmlOverride);
    }
}

