/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.nisse.source.jgit;

import eu.maveniverse.maven.nisse.core.NisseConfiguration;
import eu.maveniverse.maven.nisse.core.PropertySource;
import eu.maveniverse.maven.nisse.source.jgit.VersionInformation;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="jgit")
public class JGitPropertySource
implements PropertySource {
    public static final String NAME = "jgit";
    private static final String JGIT_COMMIT = "commit";
    private static final String JGIT_DATE = "date";
    private static final String JGIT_AUTHOR = "author";
    private static final String JGIT_COMMITTER = "committer";
    private static final String JGIT_DYNAMIC_VERSION = "dynamicVersion";
    private static final String JGIT_CONF_SYSTEM_PROPERTY_DYNAMIC_VERSION = "nisse.source.jgit.dynamicVersion";
    private static final String DEFAULT_DYNAMIC_VERSION = Boolean.FALSE.toString();
    private static final String JGIT_CONF_SYSTEM_PROPERTY_APPEND_SNAPSHOT = "nisse.source.jgit.appendSnapshot";
    private static final String DEFAULT_APPEND_SNAPSHOT = Boolean.TRUE.toString();
    private static final String JGIT_CONF_SYSTEM_PROPERTY_USE_VERSION = "nisse.source.jgit.useVersion";
    private static final String JGIT_CONF_SYSTEM_PROPERTY_DATE_FORMAT = "nisse.source.jgit.dateFormat";
    private static final String JGIT_CONF_SYSTEM_PROPERTY_DATE_FORMAT_PATTERN = "nisse.source.jgit.dateFormat.pattern";
    private static final String DEFAULT_DATE_FORMAT = "git";
    protected static final Pattern TAG_VERSION_PATTERN = Pattern.compile("refs/tags/v?((\\d+\\.\\d+\\.\\d+)(.*))");
    protected final String defaultVersion = "0.0.1";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final VersionScheme versionScheme = new GenericVersionScheme();

    public String getName() {
        return NAME;
    }

    public Map<String, String> getProperties(NisseConfiguration configuration) {
        HashMap<String, String> result = new HashMap<String, String>();
        try (Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().readEnvironment()).findGitDir(configuration.getCurrentWorkingDirectory().toFile())).setMustExist(true)).build();){
            if (repository.getDirectory() != null) {
                RevCommit lastCommit = this.getLastCommit(repository);
                result.put(JGIT_COMMIT, lastCommit.getName());
                result.put(JGIT_DATE, this.formatCommitDate(configuration, lastCommit));
                result.put(JGIT_COMMITTER, lastCommit.getCommitterIdent().toExternalString().split(">")[0] + ">");
                result.put(JGIT_AUTHOR, lastCommit.getAuthorIdent().toExternalString().split(">")[0] + ">");
                if (Boolean.parseBoolean(configuration.getConfiguration().getOrDefault(JGIT_CONF_SYSTEM_PROPERTY_DYNAMIC_VERSION, DEFAULT_DYNAMIC_VERSION))) {
                    result.put(JGIT_DYNAMIC_VERSION, this.resolveDynamicVersion(configuration, repository));
                }
            }
        }
        catch (IllegalArgumentException | RepositoryNotFoundException e) {
            this.logger.debug("Seems this is not a git checkout; ignoring property source {}", (Object)NAME, (Object)e);
        }
        catch (Exception e) {
            this.logger.error("Exception in JGitPropertySource: {}", (Object)e.toString());
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableMap(result);
    }

    private RevCommit getLastCommit(Repository repository) throws NoHeadException, GitAPIException {
        return (RevCommit)Git.wrap((Repository)repository).log().setMaxCount(1).call().iterator().next();
    }

    private String formatCommitDate(NisseConfiguration configuration, RevCommit commit) {
        DateTimeFormatter formatter = this.resolveDateTimeFormatter(configuration);
        String dateFormat = configuration.getConfiguration().getOrDefault(JGIT_CONF_SYSTEM_PROPERTY_DATE_FORMAT, DEFAULT_DATE_FORMAT);
        ZonedDateTime commitDateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(commit.getCommitTime()), commit.getAuthorIdent().getTimeZone().toZoneId());
        if ("iso8601".equalsIgnoreCase(dateFormat)) {
            commitDateTime = commitDateTime.withZoneSameInstant(ZoneOffset.UTC);
        }
        return commitDateTime.format(formatter);
    }

    private DateTimeFormatter resolveDateTimeFormatter(NisseConfiguration configuration) {
        String dateFormat = configuration.getConfiguration().getOrDefault(JGIT_CONF_SYSTEM_PROPERTY_DATE_FORMAT, DEFAULT_DATE_FORMAT);
        switch (dateFormat.toLowerCase()) {
            case "git": {
                return DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy Z");
            }
            case "iso8601": {
                return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
            }
            case "iso8601-offset": {
                return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX");
            }
            case "custom": {
                String customPattern = (String)configuration.getConfiguration().get(JGIT_CONF_SYSTEM_PROPERTY_DATE_FORMAT_PATTERN);
                if (customPattern != null && !customPattern.trim().isEmpty()) {
                    try {
                        return DateTimeFormatter.ofPattern(customPattern);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.warn("Invalid custom date format pattern '{}', falling back to default 'git' format", (Object)customPattern, (Object)e);
                        return DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy Z");
                    }
                }
                this.logger.warn("Custom date format specified but no pattern provided via '{}', falling back to default 'git' format", (Object)JGIT_CONF_SYSTEM_PROPERTY_DATE_FORMAT_PATTERN);
                return DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy Z");
            }
        }
        this.logger.warn("Unknown date format '{}', falling back to default 'git' format. Supported formats: git, iso8601, iso8601-offset, custom", (Object)dateFormat);
        return DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy Z");
    }

    public String resolveDynamicVersion(NisseConfiguration configuration, Repository repository) throws Exception {
        Optional<String> useVersion = Optional.ofNullable((String)configuration.getConfiguration().get(JGIT_CONF_SYSTEM_PROPERTY_USE_VERSION));
        VersionInformation vi = useVersion.isPresent() ? new VersionInformation(useVersion.get()) : this.getVersionFromGit(configuration, repository);
        this.logger.debug("dynamic version resvoled to: {}", (Object)vi.toString());
        return vi.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected VersionInformation getVersionFromGit(NisseConfiguration configuration, Repository repository) throws Exception {
        try (Git git = Git.wrap((Repository)repository);){
            RevCommit lastCommit = this.getLastCommit(repository);
            this.logger.debug("last commit: {}", (Object)lastCommit.toString());
            Iterable commits = git.log().call();
            int count = 0;
            for (RevCommit commit : commits) {
                Optional<VersionInformation> ovi = this.getHighestVersionTagForCommit(git, commit);
                if (ovi.isPresent()) {
                    VersionInformation vi = ovi.get();
                    if (commit.equals((AnyObjectId)lastCommit)) {
                        VersionInformation versionInformation = vi;
                        return versionInformation;
                    }
                    vi.setPatch(vi.getPatch() + 1);
                    vi.setBuildNumber(count);
                    VersionInformation versionInformation = this.mayAddSnapshotQualifier(configuration, vi);
                    return versionInformation;
                }
                ++count;
            }
            VersionInformation versionInformation = this.mayAddSnapshotQualifier(configuration, new VersionInformation("0.0.1-" + count));
            return versionInformation;
        }
        catch (GitAPIException e) {
            throw new Exception("Error reading Git information.", e);
        }
    }

    private Optional<VersionInformation> getHighestVersionTagForCommit(Git git, RevCommit commit) throws GitAPIException {
        List<String> versionTagsForCommit = this.getVersionedTagsForCommit(git, commit);
        this.logger.debug("commit {} {}: {}", new Object[]{commit.getId(), commit.getShortMessage(), versionTagsForCommit.toString()});
        Optional<VersionInformation> ovi = this.findHighestVersion(versionTagsForCommit);
        return ovi;
    }

    protected List<String> getVersionedTagsForCommit(Git git, RevCommit commit) throws GitAPIException {
        return git.tagList().call().stream().filter(tag -> {
            try {
                Ref peeledRef = git.getRepository().getRefDatabase().peel(tag);
                ObjectId id = peeledRef.getPeeledObjectId() != null ? peeledRef.getPeeledObjectId() : tag.getObjectId();
                return id.equals((AnyObjectId)commit.getId());
            }
            catch (Exception e) {
                return false;
            }
        }).map(Ref::getName).map(TAG_VERSION_PATTERN::matcher).filter(m -> m.matches() && m.groupCount() > 0).map(m -> m.group(1)).collect(Collectors.toList());
    }

    protected Optional<VersionInformation> findHighestVersion(List<String> versionTags) {
        return versionTags.stream().map(this::version).max(Comparator.comparing(version -> version)).map(Version::toString).map(VersionInformation::new);
    }

    protected Version version(String string) {
        try {
            return this.versionScheme.parseVersion(string);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    protected VersionInformation mayAddSnapshotQualifier(NisseConfiguration configuration, VersionInformation vi) {
        boolean appendSnapshot = Boolean.parseBoolean(configuration.getConfiguration().getOrDefault(JGIT_CONF_SYSTEM_PROPERTY_APPEND_SNAPSHOT, DEFAULT_APPEND_SNAPSHOT));
        if (appendSnapshot) {
            vi.setQualifier("SNAPSHOT");
        }
        return vi;
    }
}

