/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.nisse.source.jgit;

import eu.maveniverse.maven.nisse.core.NisseConfiguration;
import eu.maveniverse.maven.nisse.core.PropertySource;
import eu.maveniverse.maven.nisse.source.jgit.VersionInformation;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="jgit")
public class JGitPropertySource
implements PropertySource {
    public static final String NAME = "jgit";
    private static final String JGIT_COMMIT = "commit";
    private static final String JGIT_DATE = "date";
    private static final String JGIT_AUTHOR = "author";
    private static final String JGIT_COMMITTER = "committer";
    private static final String JGIT_DYNAMIC_VERSION = "dynamicVersion";
    private static final String JGIT_CONF_SYSTEM_PROPERTY_DYNAMIC_VERSION = "nisse.source.jgit.dynamicVersion";
    private static final String DEFAULT_DYNAMIC_VERSION = Boolean.FALSE.toString();
    private static final String JGIT_CONF_SYSTEM_PROPERTY_APPEND_BUILD_NUMBER = "nisse.source.jgit.appendBuildNumber";
    private static final String DEFAULT_APPEND_BUILD_NUMBER = Boolean.TRUE.toString();
    private static final String JGIT_CONF_SYSTEM_PROPERTY_APPEND_SNAPSHOT = "nisse.source.jgit.appendSnapshot";
    private static final String DEFAULT_APPEND_SNAPSHOT = Boolean.TRUE.toString();
    private static final String JGIT_CONF_SYSTEM_PROPERTY_USE_VERSION = "nisse.source.jgit.useVersion";
    private static final String JGIT_CONF_SYSTEM_PROPERTY_VERSION_HINT_PATTERN = "nisse.source.jgit.versionHintPattern";
    private static final String DEFAULT_VERSION_HINT_PATTERN = "${version}-SNAPSHOT";
    private static final String JGIT_CONF_SYSTEM_PROPERTY_DATE_FORMAT = "nisse.source.jgit.dateFormat";
    private static final String JGIT_CONF_SYSTEM_PROPERTY_DATE_FORMAT_PATTERN = "nisse.source.jgit.dateFormat.pattern";
    private static final String DEFAULT_DATE_FORMAT = "git";
    protected static final Pattern TAG_VERSION_PATTERN = Pattern.compile("refs/tags/v?((\\d+\\.\\d+\\.\\d+)(.*))");
    protected final String defaultVersion = "0.1.0";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final VersionScheme versionScheme = new GenericVersionScheme();

    public String getName() {
        return NAME;
    }

    public Map<String, String> getProperties(NisseConfiguration configuration) {
        HashMap<String, String> result = new HashMap<String, String>();
        try (Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().readEnvironment()).findGitDir(configuration.getCurrentWorkingDirectory().toFile())).setMustExist(true)).build();){
            if (repository.getDirectory() != null) {
                RevCommit lastCommit = this.getLastCommit(repository);
                result.put(JGIT_COMMIT, lastCommit.getName());
                result.put(JGIT_DATE, this.formatCommitDate(configuration, lastCommit));
                result.put(JGIT_COMMITTER, lastCommit.getCommitterIdent().toExternalString().split(">")[0] + ">");
                result.put(JGIT_AUTHOR, lastCommit.getAuthorIdent().toExternalString().split(">")[0] + ">");
                if (Boolean.parseBoolean(configuration.getConfiguration().getOrDefault(JGIT_CONF_SYSTEM_PROPERTY_DYNAMIC_VERSION, DEFAULT_DYNAMIC_VERSION))) {
                    result.put(JGIT_DYNAMIC_VERSION, this.resolveDynamicVersion(configuration, repository));
                }
            }
        }
        catch (IllegalArgumentException | RepositoryNotFoundException e) {
            this.logger.debug("Seems this is not a git checkout; ignoring property source {}", (Object)NAME, (Object)e);
        }
        catch (Exception e) {
            this.logger.error("Exception in JGitPropertySource: {}", (Object)e.toString());
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableMap(result);
    }

    private RevCommit getLastCommit(Repository repository) throws NoHeadException, GitAPIException {
        return (RevCommit)Git.wrap((Repository)repository).log().setMaxCount(1).call().iterator().next();
    }

    private String formatCommitDate(NisseConfiguration configuration, RevCommit commit) {
        DateTimeFormatter formatter = this.resolveDateTimeFormatter(configuration);
        String dateFormat = configuration.getConfiguration().getOrDefault(JGIT_CONF_SYSTEM_PROPERTY_DATE_FORMAT, DEFAULT_DATE_FORMAT);
        ZonedDateTime commitDateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(commit.getCommitTime()), commit.getAuthorIdent().getTimeZone().toZoneId());
        if ("iso8601".equalsIgnoreCase(dateFormat)) {
            commitDateTime = commitDateTime.withZoneSameInstant(ZoneOffset.UTC);
        }
        return commitDateTime.format(formatter);
    }

    private DateTimeFormatter resolveDateTimeFormatter(NisseConfiguration configuration) {
        String dateFormat = configuration.getConfiguration().getOrDefault(JGIT_CONF_SYSTEM_PROPERTY_DATE_FORMAT, DEFAULT_DATE_FORMAT);
        switch (dateFormat.toLowerCase()) {
            case "git": {
                return DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy Z", Locale.ENGLISH);
            }
            case "iso8601": {
                return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
            }
            case "iso8601-offset": {
                return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX");
            }
            case "custom": {
                String customPattern = (String)configuration.getConfiguration().get(JGIT_CONF_SYSTEM_PROPERTY_DATE_FORMAT_PATTERN);
                if (customPattern != null && !customPattern.trim().isEmpty()) {
                    try {
                        return DateTimeFormatter.ofPattern(customPattern);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.warn("Invalid custom date format pattern '{}', falling back to default 'git' format", (Object)customPattern, (Object)e);
                        return DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy Z", Locale.ENGLISH);
                    }
                }
                this.logger.warn("Custom date format specified but no pattern provided via '{}', falling back to default 'git' format", (Object)JGIT_CONF_SYSTEM_PROPERTY_DATE_FORMAT_PATTERN);
                return DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy Z", Locale.ENGLISH);
            }
        }
        this.logger.warn("Unknown date format '{}', falling back to default 'git' format. Supported formats: git, iso8601, iso8601-offset, custom", (Object)dateFormat);
        return DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy Z", Locale.ENGLISH);
    }

    public String resolveDynamicVersion(NisseConfiguration configuration, Repository repository) throws Exception {
        VersionInformation vi;
        Optional<String> useVersion = Optional.ofNullable((String)configuration.getConfiguration().get(JGIT_CONF_SYSTEM_PROPERTY_USE_VERSION));
        if (useVersion.isPresent()) {
            vi = new VersionInformation(useVersion.get());
            this.logger.debug("Using explicit version from useVersion property: {}", (Object)useVersion.get());
        } else {
            VersionInformation gitHistoryVersion = this.getVersionFromGit(configuration, repository);
            this.logger.debug("Version from git history: {}", (Object)gitHistoryVersion.toString());
            String versionHintPattern = configuration.getConfiguration().getOrDefault(JGIT_CONF_SYSTEM_PROPERTY_VERSION_HINT_PATTERN, DEFAULT_VERSION_HINT_PATTERN);
            boolean isCustomPattern = !DEFAULT_VERSION_HINT_PATTERN.equals(versionHintPattern);
            Optional<String> versionHint = this.findVersionHint(configuration, repository);
            if (versionHint.isPresent()) {
                VersionInformation hintVersion = new VersionInformation(versionHint.get());
                this.logger.debug("Version hint found: {}", (Object)hintVersion.toString());
                if (isCustomPattern) {
                    vi = this.mayAddSnapshotQualifier(configuration, hintVersion);
                    this.logger.debug("Using version hint (custom pattern): {}", (Object)versionHint.get());
                } else {
                    boolean isDefaultGitVersion;
                    boolean bl = isDefaultGitVersion = gitHistoryVersion.getMajor() == 0 && gitHistoryVersion.getMinor() == 1 && gitHistoryVersion.getPatch() == 0;
                    if (isDefaultGitVersion) {
                        vi = this.mayAddSnapshotQualifier(configuration, hintVersion);
                        this.logger.debug("Using version hint (no regular release tags found): {}", (Object)versionHint.get());
                    } else {
                        Version gitHistoryVersionParsed = this.version(gitHistoryVersion.toString());
                        Version hintVersionParsed = this.version(hintVersion.toString());
                        if (hintVersionParsed.compareTo((Object)gitHistoryVersionParsed) > 0) {
                            vi = this.mayAddSnapshotQualifier(configuration, hintVersion);
                            this.logger.debug("Using version hint (higher than git history): {}", (Object)versionHint.get());
                        } else {
                            vi = gitHistoryVersion;
                            this.logger.debug("Using git history version (higher than or equal to version hint): {}", (Object)gitHistoryVersion.toString());
                        }
                    }
                }
            } else {
                vi = gitHistoryVersion;
                this.logger.debug("Using version resolved from git history (no version hint found)");
            }
        }
        this.logger.debug("dynamic version resolved to: {}", (Object)vi.toString());
        return vi.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected VersionInformation getVersionFromGit(NisseConfiguration configuration, Repository repository) throws Exception {
        try (Git git = Git.wrap((Repository)repository);){
            RevCommit lastCommit = this.getLastCommit(repository);
            this.logger.debug("last commit: {}", (Object)lastCommit.toString());
            Iterable commits = git.log().call();
            int count = 0;
            for (RevCommit commit : commits) {
                Optional<VersionInformation> ovi = this.getHighestVersionTagForCommit(configuration, git, commit);
                if (ovi.isPresent()) {
                    VersionInformation vi = ovi.get();
                    if (commit.equals((AnyObjectId)lastCommit)) {
                        VersionInformation versionInformation = vi;
                        return versionInformation;
                    }
                    vi.setPatch(vi.getPatch() + 1);
                    boolean appendBuildNumber = Boolean.parseBoolean(configuration.getConfiguration().getOrDefault(JGIT_CONF_SYSTEM_PROPERTY_APPEND_BUILD_NUMBER, DEFAULT_APPEND_BUILD_NUMBER));
                    if (appendBuildNumber) {
                        vi.setBuildNumber(count);
                    }
                    VersionInformation versionInformation = this.mayAddSnapshotQualifier(configuration, vi);
                    return versionInformation;
                }
                ++count;
            }
            VersionInformation versionInformation = this.mayAddSnapshotQualifier(configuration, new VersionInformation("0.1.0-" + count));
            return versionInformation;
        }
        catch (GitAPIException e) {
            throw new Exception("Error reading Git information.", e);
        }
    }

    private Optional<VersionInformation> getHighestVersionTagForCommit(NisseConfiguration configuration, Git git, RevCommit commit) throws GitAPIException {
        List<String> versionTagsForCommit = this.getVersionedTagsForCommit(configuration, git, commit);
        this.logger.debug("commit {} {}: {}", new Object[]{commit.getId(), commit.getShortMessage(), versionTagsForCommit.toString()});
        Optional<VersionInformation> ovi = this.findHighestVersion(versionTagsForCommit);
        return ovi;
    }

    protected List<String> getVersionedTagsForCommit(NisseConfiguration configuration, Git git, RevCommit commit) throws GitAPIException {
        String versionHintPattern = configuration.getConfiguration().getOrDefault(JGIT_CONF_SYSTEM_PROPERTY_VERSION_HINT_PATTERN, DEFAULT_VERSION_HINT_PATTERN);
        boolean isCustomPattern = !DEFAULT_VERSION_HINT_PATTERN.equals(versionHintPattern);
        return git.tagList().call().stream().filter(tag -> {
            try {
                Ref peeledRef = git.getRepository().getRefDatabase().peel(tag);
                ObjectId id = peeledRef.getPeeledObjectId() != null ? peeledRef.getPeeledObjectId() : tag.getObjectId();
                return id.equals((AnyObjectId)commit.getId());
            }
            catch (Exception e) {
                return false;
            }
        }).map(Ref::getName).filter(tagName -> {
            if (isCustomPattern) {
                return this.isVersionHintTag(configuration, (String)tagName);
            }
            return !this.isVersionHintTag(configuration, (String)tagName);
        }).map(TAG_VERSION_PATTERN::matcher).filter(m -> m.matches() && m.groupCount() > 0).map(m -> m.group(1)).collect(Collectors.toList());
    }

    protected Optional<VersionInformation> findHighestVersion(List<String> versionTags) {
        return versionTags.stream().map(this::version).max(Comparator.comparing(version -> version)).map(Version::toString).map(VersionInformation::new);
    }

    protected Version version(String string) {
        try {
            return this.versionScheme.parseVersion(string);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    protected VersionInformation mayAddSnapshotQualifier(NisseConfiguration configuration, VersionInformation vi) {
        boolean appendSnapshot = Boolean.parseBoolean(configuration.getConfiguration().getOrDefault(JGIT_CONF_SYSTEM_PROPERTY_APPEND_SNAPSHOT, DEFAULT_APPEND_SNAPSHOT));
        if (appendSnapshot) {
            vi.setQualifier("SNAPSHOT");
        }
        return vi;
    }

    protected Optional<String> findVersionHint(NisseConfiguration configuration, Repository repository) throws Exception {
        Optional<String> optional;
        block8: {
            Git git = Git.wrap((Repository)repository);
            try {
                String hintPattern = configuration.getConfiguration().getOrDefault(JGIT_CONF_SYSTEM_PROPERTY_VERSION_HINT_PATTERN, DEFAULT_VERSION_HINT_PATTERN);
                List<String> hintVersions = this.findVersionHintTags(git, hintPattern);
                this.logger.debug("Found version hint tags: {}", hintVersions);
                optional = this.findHighestVersionFromHints(hintVersions);
                if (git == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (GitAPIException e) {
                    throw new Exception("Error reading version hint tags from Git.", e);
                }
            }
            git.close();
        }
        return optional;
    }

    protected List<String> findVersionHintTags(Git git, String hintPattern) throws GitAPIException {
        String regexPattern = hintPattern.replace(".", "\\.").replace("-", "\\-");
        regexPattern = regexPattern.replace("${version}", "(\\d+\\.\\d+\\.\\d+)");
        Pattern hintTagPattern = Pattern.compile("refs/tags/v?" + regexPattern);
        this.logger.debug("Using version hint regex pattern: {}", (Object)hintTagPattern.pattern());
        return git.tagList().call().stream().map(Ref::getName).map(hintTagPattern::matcher).filter(m -> m.matches() && m.groupCount() > 0).map(m -> m.group(1)).collect(Collectors.toList());
    }

    protected Optional<String> findHighestVersionFromHints(List<String> hintVersions) {
        return hintVersions.stream().max(Comparator.comparing(this::version));
    }

    protected boolean isVersionHintTag(NisseConfiguration configuration, String tagName) {
        String versionHintPattern = configuration.getConfiguration().getOrDefault(JGIT_CONF_SYSTEM_PROPERTY_VERSION_HINT_PATTERN, DEFAULT_VERSION_HINT_PATTERN);
        String regexPattern = versionHintPattern.replace(".", "\\.").replace("-", "\\-");
        regexPattern = regexPattern.replace("${version}", "(\\d+\\.\\d+\\.\\d+)");
        Pattern hintTagPattern = Pattern.compile("refs/tags/v?" + regexPattern);
        return hintTagPattern.matcher(tagName).matches();
    }
}

