/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.nisse.source.mvn;

import eu.maveniverse.maven.nisse.core.NisseConfiguration;
import eu.maveniverse.maven.nisse.core.PropertySource;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
@Named(value="mvn")
public class MvnPropertySource
implements PropertySource {
    public static final String NAME = "mvn";
    private static final String VERSION = "version";
    private static final String VERSION_MAJOR = "major";
    private static final String VERSION_MINOR = "minor";
    private static final String VERSION_MAJOR_MINOR = "majorMinor";
    private static final String VERSION_PATCH = "patch";
    private static final String VERSION_QUALIFIER = "qualifier";

    public String getName() {
        return NAME;
    }

    public Map<String, String> getProperties(NisseConfiguration configuration) {
        Properties mavenBuildProperties;
        String mavenVersion = (String)configuration.getConfiguration().get("maven.version");
        HashMap<String, String> result = new HashMap<String, String>();
        if (mavenVersion != null) {
            result.put(VERSION, mavenVersion);
            if (mavenVersion.contains("-")) {
                int qIdx = mavenVersion.indexOf(45);
                result.put(VERSION_QUALIFIER, mavenVersion.substring(qIdx + 1));
                mavenVersion = mavenVersion.substring(0, qIdx);
            }
            String[] elems = mavenVersion.split("\\.");
            result.put(VERSION_MAJOR, elems[0]);
            result.put(VERSION_MINOR, elems[1]);
            result.put(VERSION_MAJOR_MINOR, elems[0] + "." + elems[1]);
            result.put(VERSION_PATCH, elems[2]);
        }
        if (!(mavenBuildProperties = MvnPropertySource.getMavenBuildProperties(configuration)).isEmpty()) {
            mavenBuildProperties.stringPropertyNames().forEach(k -> result.put((String)k, mavenBuildProperties.getProperty((String)k)));
        }
        return Collections.unmodifiableMap(result);
    }

    private static Properties getMavenBuildProperties(NisseConfiguration configuration) {
        Properties properties;
        block14: {
            String mavenHome = (String)configuration.getConfiguration().get("maven.home");
            String mavenVersion = (String)configuration.getConfiguration().get("maven.version");
            properties = new Properties();
            try {
                Path mavenCoreJarPath;
                if (mavenHome == null || mavenVersion == null || !Files.isRegularFile(mavenCoreJarPath = Paths.get(mavenHome, new String[0]).resolve("lib/maven-core-" + mavenVersion + ".jar"), new LinkOption[0])) break block14;
                try (FileSystem fs = FileSystems.newFileSystem(mavenCoreJarPath, (ClassLoader)null);
                     InputStream input = Files.newInputStream(fs.getPath("/org/apache/maven/messages/build.properties", new String[0]), new OpenOption[0]);){
                    properties.load(input);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return properties;
    }
}

