/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.rewrite;

import com.atlassian.maven.plugins.jgitflow.exception.ProjectRewriteException;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChangeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ArtifactReleaseVersionChange
implements ProjectChange {
    private static final String LF = System.getProperty("line.separator") + "  - ";
    private final Map<String, String> originalVersions;
    private final Map<String, String> releaseVersions;
    private final boolean updateDependencies;
    private StringBuilder workLog;

    private ArtifactReleaseVersionChange(Map<String, String> originalVersions, Map<String, String> releaseVersions, boolean updateDependencies) {
        this.originalVersions = originalVersions;
        this.releaseVersions = releaseVersions;
        this.updateDependencies = updateDependencies;
        this.workLog = new StringBuilder("[Update Artifact Versions]");
    }

    public static ArtifactReleaseVersionChange artifactReleaseVersionChange(Map<String, String> originalVersions, Map<String, String> releaseVersions, boolean updateDependencies) {
        return new ArtifactReleaseVersionChange(originalVersions, releaseVersions, updateDependencies);
    }

    @Override
    public boolean applyChange(MavenProject project, Element root, String eol) throws ProjectRewriteException {
        boolean modified = false;
        Namespace ns = ProjectChangeUtils.getNamespaceOrNull(root);
        Element properties = root.getChild("properties", ns);
        ArrayList<Element> artifactContainers = new ArrayList<Element>();
        artifactContainers.add(root);
        artifactContainers.addAll(ProjectChangeUtils.getElementListOrEmpty(root, "profiles/profile", ns));
        for (Element artifactContainer : artifactContainers) {
            modified |= this.rewriteDependencies(artifactContainer, project, properties, ns);
            modified |= this.rewriteDependencyManagement(artifactContainer, project, properties, ns);
            modified |= this.rewriteBuildExtensions(artifactContainer, project, properties, ns);
            modified |= this.rewritePluginElements(artifactContainer, project, properties, ns);
            modified |= this.rewriteReportingPlugins(artifactContainer, project, properties, ns);
        }
        return modified;
    }

    private boolean rewriteDependencies(Element artifactContainer, MavenProject project, Element properties, Namespace ns) throws ProjectRewriteException {
        List<Element> artifacts = ProjectChangeUtils.getElementListOrEmpty(artifactContainer, "dependencies/dependency", ns);
        return this.rewriteArtifactVersions(artifacts, project, properties, ns);
    }

    private boolean rewriteDependencyManagement(Element artifactContainer, MavenProject project, Element properties, Namespace ns) throws ProjectRewriteException {
        List<Element> artifacts = ProjectChangeUtils.getElementListOrEmpty(artifactContainer, "dependencyManagement/dependencies/dependency", ns);
        return this.rewriteArtifactVersions(artifacts, project, properties, ns);
    }

    private boolean rewriteBuildExtensions(Element artifactContainer, MavenProject project, Element properties, Namespace ns) throws ProjectRewriteException {
        List<Element> artifacts = ProjectChangeUtils.getElementListOrEmpty(artifactContainer, "build/extensions/extension", ns);
        return this.rewriteArtifactVersions(artifacts, project, properties, ns);
    }

    private boolean rewritePluginElements(Element artifactContainer, MavenProject project, Element properties, Namespace ns) throws ProjectRewriteException {
        boolean modified = false;
        ArrayList<Element> pluginElements = new ArrayList<Element>();
        pluginElements.addAll(ProjectChangeUtils.getElementListOrEmpty(artifactContainer, "build/plugins/plugin", ns));
        pluginElements.addAll(ProjectChangeUtils.getElementListOrEmpty(artifactContainer, "build/pluginManagement/plugins/plugin", ns));
        modified |= this.rewriteArtifactVersions(pluginElements, project, properties, ns);
        for (Element pluginElement : pluginElements) {
            List<Element> artifacts = ProjectChangeUtils.getElementListOrEmpty(pluginElement, "dependencies/dependency", ns);
            modified |= this.rewriteArtifactVersions(artifacts, project, properties, ns);
        }
        return modified;
    }

    private boolean rewriteReportingPlugins(Element artifactContainer, MavenProject project, Element properties, Namespace ns) throws ProjectRewriteException {
        List<Element> artifacts = ProjectChangeUtils.getElementListOrEmpty(artifactContainer, "reporting/plugins/plugin", ns);
        return this.rewriteArtifactVersions(artifacts, project, properties, ns);
    }

    private boolean rewriteArtifactVersions(List<Element> artifacts, MavenProject project, Element properties, Namespace ns) throws ProjectRewriteException {
        boolean modified = false;
        Model projectModel = project.getModel();
        if (null == artifacts || artifacts.isEmpty()) {
            return false;
        }
        String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
        for (Element artifact : artifacts) {
            Element versionElement = artifact.getChild("version", ns);
            if (null == versionElement) continue;
            String rawVersion = versionElement.getTextTrim();
            Element groupIdElement = artifact.getChild("groupId", ns);
            if (null == groupIdElement) {
                if (!"plugin".equals(artifact.getName())) continue;
                groupIdElement = new Element("groupId");
                groupIdElement.setText("org.apache.maven.plugins");
            }
            String groupId = null;
            String artifactId = null;
            try {
                groupId = ReleaseUtil.interpolate((String)groupIdElement.getTextTrim(), (Model)projectModel);
                Element artifactIdElement = artifact.getChild("artifactId", ns);
                if (null == artifactIdElement) continue;
                artifactId = ReleaseUtil.interpolate((String)artifactIdElement.getTextTrim(), (Model)projectModel);
            }
            catch (ReleaseExecutionException e) {
                throw new ProjectRewriteException("error interpolating pom variable: " + e.getMessage(), e);
            }
            String artifactKey = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
            String mappedVersion = this.releaseVersions.get(artifactKey);
            String originalVersion = this.originalVersions.get(artifactKey);
            if (null != mappedVersion && mappedVersion.endsWith("SNAPSHOT") && !rawVersion.endsWith("SNAPSHOT") && !this.updateDependencies || null == mappedVersion) continue;
            if (rawVersion.equals(originalVersion)) {
                this.workLog.append(LF).append("updating ").append(artifactId).append(" to ").append(mappedVersion);
                versionElement.setText(mappedVersion);
                modified = true;
                continue;
            }
            if (!rawVersion.matches("\\$\\{.+\\}")) continue;
            String propName = rawVersion.substring(2, rawVersion.length() - 1);
            if (propName.startsWith("project.") || propName.startsWith("pom.") || "version".equals(propName)) {
                if (mappedVersion.equals(this.releaseVersions.get(projectId))) continue;
                this.workLog.append(LF).append("updating ").append(artifactId).append(" to ").append(mappedVersion);
                versionElement.setText(mappedVersion);
                modified = true;
                continue;
            }
            if (null == properties) continue;
            Element prop = properties.getChild(propName, ns);
            if (null != prop) {
                String propValue = prop.getTextTrim();
                if (propValue.equals(originalVersion)) {
                    this.workLog.append(LF).append("updating ").append(rawVersion).append(" to ").append(mappedVersion);
                    prop.setText(mappedVersion);
                    modified = true;
                    continue;
                }
                if (mappedVersion.equals(rawVersion) || mappedVersion.matches("\\$\\{project.+\\}") || mappedVersion.matches("\\$\\{pom.+\\}") || "${version}".equals(mappedVersion)) continue;
                throw new ProjectRewriteException("The artifact (" + artifactKey + ") requires a " + "different version (" + mappedVersion + ") than what is found (" + propValue + ") for the expression (" + propName + ") in the " + "project (" + projectId + ").");
            }
            throw new ProjectRewriteException("Error updating version '" + rawVersion + "' for artifact " + artifactKey);
        }
        return modified;
    }

    public String toString() {
        return this.workLog.toString();
    }
}

