/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.shaded.glassfish.json;

import fish.payara.arquillian.shaded.glassfish.json.JsonArrayBuilderImpl;
import fish.payara.arquillian.shaded.glassfish.json.JsonMessages;
import fish.payara.arquillian.shaded.glassfish.json.JsonObjectBuilderImpl;
import fish.payara.arquillian.shaded.glassfish.json.JsonUtil;
import fish.payara.arquillian.shaded.jakarta.json.JsonArray;
import fish.payara.arquillian.shaded.jakarta.json.JsonException;
import fish.payara.arquillian.shaded.jakarta.json.JsonObject;
import fish.payara.arquillian.shaded.jakarta.json.JsonStructure;
import fish.payara.arquillian.shaded.jakarta.json.JsonValue;

abstract class NodeReference {
    NodeReference() {
    }

    public abstract boolean contains();

    public abstract JsonValue get();

    public abstract JsonStructure add(JsonValue var1);

    public abstract JsonStructure remove();

    public abstract JsonStructure replace(JsonValue var1);

    public static NodeReference of(JsonStructure structure) {
        return new RootReference(structure);
    }

    public static NodeReference of(JsonObject object, String name) {
        return new ObjectReference(object, name);
    }

    public static NodeReference of(JsonArray array, int index) {
        return new ArrayReference(array, index);
    }

    static class ArrayReference
    extends NodeReference {
        private final JsonArray array;
        private final int index;

        ArrayReference(JsonArray array, int index) {
            this.array = array;
            this.index = index;
        }

        @Override
        public boolean contains() {
            return this.array != null && this.index > -1 && this.index < this.array.size();
        }

        @Override
        public JsonValue get() {
            if (!this.contains()) {
                throw new JsonException(JsonMessages.NODEREF_ARRAY_INDEX_ERR(this.index, this.array.size()));
            }
            return (JsonValue)this.array.get(this.index);
        }

        @Override
        public JsonArray add(JsonValue value) {
            JsonArrayBuilderImpl builder = new JsonArrayBuilderImpl(this.array, JsonUtil.getInternalBufferPool());
            if (this.index == -1 || this.index == this.array.size()) {
                builder.add(value);
            } else if (this.index < this.array.size()) {
                builder.add(this.index, value);
            } else {
                throw new JsonException(JsonMessages.NODEREF_ARRAY_INDEX_ERR(this.index, this.array.size()));
            }
            return builder.build();
        }

        @Override
        public JsonArray remove() {
            if (!this.contains()) {
                throw new JsonException(JsonMessages.NODEREF_ARRAY_INDEX_ERR(this.index, this.array.size()));
            }
            JsonArrayBuilderImpl builder = new JsonArrayBuilderImpl(this.array, JsonUtil.getInternalBufferPool());
            return builder.remove(this.index).build();
        }

        @Override
        public JsonArray replace(JsonValue value) {
            if (!this.contains()) {
                throw new JsonException(JsonMessages.NODEREF_ARRAY_INDEX_ERR(this.index, this.array.size()));
            }
            JsonArrayBuilderImpl builder = new JsonArrayBuilderImpl(this.array, JsonUtil.getInternalBufferPool());
            return builder.set(this.index, value).build();
        }
    }

    static class ObjectReference
    extends NodeReference {
        private final JsonObject object;
        private final String key;

        ObjectReference(JsonObject object, String key) {
            this.object = object;
            this.key = key;
        }

        @Override
        public boolean contains() {
            return this.object != null && this.object.containsKey(this.key);
        }

        @Override
        public JsonValue get() {
            if (!this.contains()) {
                throw new JsonException(JsonMessages.NODEREF_OBJECT_MISSING(this.key));
            }
            return (JsonValue)this.object.get(this.key);
        }

        @Override
        public JsonObject add(JsonValue value) {
            return new JsonObjectBuilderImpl(this.object, JsonUtil.getInternalBufferPool()).add(this.key, value).build();
        }

        @Override
        public JsonObject remove() {
            if (!this.contains()) {
                throw new JsonException(JsonMessages.NODEREF_OBJECT_MISSING(this.key));
            }
            return new JsonObjectBuilderImpl(this.object, JsonUtil.getInternalBufferPool()).remove(this.key).build();
        }

        @Override
        public JsonObject replace(JsonValue value) {
            if (!this.contains()) {
                throw new JsonException(JsonMessages.NODEREF_OBJECT_MISSING(this.key));
            }
            return this.add(value);
        }
    }

    static class RootReference
    extends NodeReference {
        private JsonStructure root;

        RootReference(JsonStructure root) {
            this.root = root;
        }

        @Override
        public boolean contains() {
            return this.root != null;
        }

        @Override
        public JsonValue get() {
            return this.root;
        }

        @Override
        public JsonStructure add(JsonValue value) {
            switch (value.getValueType()) {
                case OBJECT: 
                case ARRAY: {
                    this.root = (JsonStructure)value;
                    break;
                }
                default: {
                    throw new JsonException(JsonMessages.NODEREF_VALUE_ADD_ERR());
                }
            }
            return this.root;
        }

        @Override
        public JsonStructure remove() {
            throw new JsonException(JsonMessages.NODEREF_VALUE_CANNOT_REMOVE());
        }

        @Override
        public JsonStructure replace(JsonValue value) {
            return this.add(value);
        }
    }
}

