/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.container.payara.clientutils;

import fish.payara.arquillian.container.payara.CommonPayaraConfiguration;
import fish.payara.arquillian.container.payara.clientutils.PayaraClientException;
import fish.payara.arquillian.shaded.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import fish.payara.arquillian.shaded.glassfish.jersey.client.filter.CsrfProtectionFilter;
import fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.FormDataMultiPart;
import fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.MultiPartFeature;
import fish.payara.arquillian.shaded.jakarta.ws.rs.client.Client;
import fish.payara.arquillian.shaded.jakarta.ws.rs.client.ClientBuilder;
import fish.payara.arquillian.shaded.jakarta.ws.rs.client.Entity;
import fish.payara.arquillian.shaded.jakarta.ws.rs.client.Invocation;
import fish.payara.arquillian.shaded.jakarta.ws.rs.core.Feature;
import fish.payara.arquillian.shaded.jakarta.ws.rs.core.MediaType;
import fish.payara.arquillian.shaded.jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class PayaraClientUtil {
    private static final Logger log = Logger.getLogger(PayaraClientUtil.class.getName());
    public static final String SUCCESS = "SUCCESS";
    public static final String WARNING = "WARNING";
    private final CommonPayaraConfiguration configuration;
    private final String adminBaseUrl;

    public PayaraClientUtil(CommonPayaraConfiguration configuration, String adminBaseUrl) {
        this.configuration = configuration;
        this.adminBaseUrl = adminBaseUrl;
    }

    public CommonPayaraConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<String, String> getAttributes(String additionalResourceUrl) {
        Map<String, Object> extraProperties = this.getExtraProperties(this.GETRequest(additionalResourceUrl));
        if (extraProperties != null) {
            return (Map)extraProperties.get("entity");
        }
        return new HashMap<String, String>();
    }

    public Map<String, String> getChildResources(String additionalResourceUrl) {
        Map<String, Object> extraProperties = this.getExtraProperties(this.GETRequest(additionalResourceUrl));
        if (extraProperties != null) {
            return (Map)extraProperties.get("childResources");
        }
        return new HashMap<String, String>();
    }

    public Map<String, Object> GETRequest(String additionalResourceUrl) {
        return this.getResponseMap("<non-application-specific>", this.prepareClient(additionalResourceUrl, new Class[0]).get());
    }

    public List<Map<String, Object>> getInstancesList(String additionalResourceUrl) {
        Map<String, Object> extraProperties = this.getExtraProperties(this.GETRequest(additionalResourceUrl));
        if (extraProperties != null) {
            return this.getInstanceList(extraProperties);
        }
        return new ArrayList<Map<String, Object>>();
    }

    public Map<String, String> getServerSystemProperties(String additionalResourceUrl) {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        String message = this.getMessage(this.GETRequest(additionalResourceUrl));
        int systemPropertiesHeader = message.indexOf("List of System Properties for the Java Virtual Machine:");
        if (systemPropertiesHeader != -1) {
            String systemMessage = message.substring(systemPropertiesHeader + "List of System Properties for the Java Virtual Machine:".length());
            for (String line : systemMessage.split("(\\r\\n|\\r|\\n)")) {
                if (!line.contains("=")) continue;
                String[] keyValue = line.split("=");
                systemProperties.put(keyValue[0].trim(), keyValue[1].trim());
            }
        }
        return systemProperties;
    }

    public Map<String, Object> getExtraProperties(Map<String, Object> responseMap) {
        return (Map)responseMap.get("extraProperties");
    }

    public String getMessage(Map<String, Object> responseMap) {
        return (String)responseMap.get("message");
    }

    private List<Map<String, Object>> getInstanceList(Map<String, Object> resultExtraProperties) {
        return (List)resultExtraProperties.get("instanceList");
    }

    public Map<String, Object> POSTMultiPartRequest(String name, String additionalResourceUrl, FormDataMultiPart form) {
        return this.getResponseMap(name, this.prepareClient(additionalResourceUrl, MultiPartFeature.class).post(Entity.entity(form, form.getMediaType())));
    }

    @SafeVarargs
    private final Invocation.Builder prepareClient(String additionalResourceUrl, Class<? extends Feature> ... features) {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            // empty catch block
        }
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        if (this.configuration.isIgnoreCertificates() && sslContext != null) {
            clientBuilder.sslContext(sslContext).hostnameVerifier((hostname, session) -> true);
        } else if (sslContext == null) {
            log.warning("Unable to ignore SSL certificate information");
        }
        Client client = clientBuilder.build();
        if (this.configuration.isAuthorisation()) {
            client.register(HttpAuthenticationFeature.basic(this.configuration.getAdminUser(), this.configuration.getAdminPassword()));
        }
        client.register(new CsrfProtectionFilter());
        for (Class<? extends Feature> feature : features) {
            client.register(feature);
        }
        return client.target(this.adminBaseUrl + additionalResourceUrl).request(MediaType.APPLICATION_XML_TYPE).header("X-GlassFish-3", "ignore");
    }

    private Map<String, Object> getResponseMap(String name, Response response) {
        Response.StatusType status;
        Map<Object, Object> responseMap = new HashMap();
        Object message = String.format("While Deploying Application: %s --", name);
        String xmlDoc = response.readEntity(String.class);
        if (xmlDoc != null && !xmlDoc.isEmpty()) {
            responseMap = this.xmlToMap(xmlDoc);
            message = (String)message + "exit_code: " + responseMap.get("exit_code") + ", message: " + responseMap.get("message");
        }
        if ((status = response.getStatusInfo()).getFamily() == Response.Status.Family.SUCCESSFUL) {
            if (responseMap.get("exit_code") == null) {
                throw new PayaraClientException((String)message);
            }
            if (WARNING.equals(responseMap.get("exit_code"))) {
                log.log(Level.WARNING, "Deployment resulted in a warning: {0}", message);
            } else if (!SUCCESS.equals(responseMap.get("exit_code"))) {
                throw new PayaraClientException((String)message);
            }
        } else if ("Not Found".equals(status.getReasonPhrase())) {
            message = (String)message + " [status: " + status.getFamily() + " reason: " + status.getReasonPhrase() + "]";
            log.warning((String)message);
        } else {
            message = (String)message + " [status: " + status.getFamily() + " reason: " + status.getReasonPhrase() + "]";
            log.severe((String)message);
            throw new PayaraClientException((String)message);
        }
        return responseMap;
    }

    public Map<String, Object> xmlToMap(String document) {
        if (document == null) {
            return new HashMap<String, Object>();
        }
        Map<String, Object> map = null;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isValidating", false);
        try (ByteArrayInputStream input = new ByteArrayInputStream(document.trim().getBytes("UTF-8"));){
            XMLStreamReader stream = factory.createXMLStreamReader(input);
            while (stream.hasNext()) {
                if (stream.next() != 1 || !"map".equals(stream.getLocalName())) continue;
                map = this.resolveXmlMap(stream);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        return map;
    }

    private Map<String, Object> resolveXmlMap(XMLStreamReader stream) throws XMLStreamException {
        boolean endMapFlag = false;
        HashMap<String, Object> entry = new HashMap<String, Object>();
        String key = null;
        String elementName = null;
        block14: while (!endMapFlag) {
            int currentEvent = stream.next();
            switch (currentEvent) {
                case 1: {
                    if (null == stream.getLocalName()) {
                        elementName = stream.getLocalName();
                        break;
                    }
                    switch (stream.getLocalName()) {
                        case "entry": {
                            key = stream.getAttributeValue(null, "key");
                            String value = stream.getAttributeValue(null, "value");
                            if (value == null) continue block14;
                            entry.put(key, value);
                            key = null;
                            break;
                        }
                        case "map": {
                            entry.put(key, this.resolveXmlMap(stream));
                            break;
                        }
                        case "list": {
                            entry.put(key, this.resolveXmlList(stream));
                            break;
                        }
                        default: {
                            elementName = stream.getLocalName();
                            break;
                        }
                    }
                    continue block14;
                }
                case 2: {
                    if ("map".equals(stream.getLocalName())) {
                        endMapFlag = true;
                    }
                    elementName = null;
                    break;
                }
                default: {
                    String document = stream.getText();
                    if (elementName == null) continue block14;
                    if ("number".equals(elementName)) {
                        if (document.contains(".")) {
                            entry.put(key, Double.parseDouble(document));
                        } else {
                            entry.put(key, Long.parseLong(document));
                        }
                    } else if ("string".equals(elementName)) {
                        entry.put(key, document);
                    }
                    elementName = null;
                }
            }
        }
        return entry;
    }

    private List<Object> resolveXmlList(XMLStreamReader stream) throws XMLStreamException {
        boolean endListFlag = false;
        ArrayList<Object> list = new ArrayList<Object>();
        String elementName = null;
        block4: while (!endListFlag) {
            int currentEvent = stream.next();
            switch (currentEvent) {
                case 1: {
                    if ("map".equals(stream.getLocalName())) {
                        list.add(this.resolveXmlMap(stream));
                        continue block4;
                    }
                    elementName = stream.getLocalName();
                    continue block4;
                }
                case 2: {
                    if ("list".equals(stream.getLocalName())) {
                        endListFlag = true;
                    }
                    elementName = null;
                    continue block4;
                }
            }
            String document = stream.getText();
            if (elementName == null) continue;
            if ("number".equals(elementName)) {
                if (document.contains(".")) {
                    list.add(Double.parseDouble(document));
                } else {
                    list.add(Long.parseLong(document));
                }
            } else if ("string".equals(elementName)) {
                list.add(document);
            }
            elementName = null;
        }
        return list;
    }
}

