/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.internal;

import fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.BodyPart;
import fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.BodyPartEntity;
import fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.Boundary;
import fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.MultiPart;
import fish.payara.arquillian.shaded.glassfish.jersey.media.multipart.internal.LocalizationMessages;
import fish.payara.arquillian.shaded.glassfish.jersey.message.MessageUtils;
import fish.payara.arquillian.shaded.jakarta.inject.Singleton;
import fish.payara.arquillian.shaded.jakarta.ws.rs.Produces;
import fish.payara.arquillian.shaded.jakarta.ws.rs.WebApplicationException;
import fish.payara.arquillian.shaded.jakarta.ws.rs.core.Context;
import fish.payara.arquillian.shaded.jakarta.ws.rs.core.GenericEntity;
import fish.payara.arquillian.shaded.jakarta.ws.rs.core.MediaType;
import fish.payara.arquillian.shaded.jakarta.ws.rs.core.MultivaluedMap;
import fish.payara.arquillian.shaded.jakarta.ws.rs.ext.MessageBodyWriter;
import fish.payara.arquillian.shaded.jakarta.ws.rs.ext.Providers;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

@Singleton
@Produces(value={"multipart/*"})
public class MultiPartWriter
implements MessageBodyWriter<MultiPart> {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final Providers providers;

    public MultiPartWriter(@Context Providers providers) {
        this.providers = providers;
    }

    @Override
    public long getSize(MultiPart entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultiPart.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(MultiPart entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream stream) throws IOException, WebApplicationException {
        Object value;
        if (entity.getBodyParts() == null || entity.getBodyParts().size() < 1) {
            throw new IllegalArgumentException(LocalizationMessages.MUST_SPECIFY_BODY_PART());
        }
        if (entity.getParent() == null && (value = headers.getFirst("MIME-Version")) == null) {
            headers.putSingle("MIME-Version", "1.0");
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, MessageUtils.getCharset(mediaType)));
        MediaType boundaryMediaType = Boundary.addBoundary(mediaType);
        if (boundaryMediaType != mediaType) {
            headers.putSingle("Content-Type", boundaryMediaType.toString());
        }
        String boundaryString = boundaryMediaType.getParameters().get("boundary");
        boolean isFirst = true;
        for (BodyPart bodyPart : entity.getBodyParts()) {
            MessageBodyWriter<?> bodyWriter;
            if (isFirst) {
                isFirst = false;
                writer.write("--");
            } else {
                writer.write("\r\n--");
            }
            writer.write(boundaryString);
            writer.write("\r\n");
            MediaType bodyMediaType = bodyPart.getMediaType();
            if (bodyMediaType == null) {
                throw new IllegalArgumentException(LocalizationMessages.MISSING_MEDIA_TYPE_OF_BODY_PART());
            }
            MultivaluedMap<String, Object> bodyHeaders = bodyPart.getHeaders();
            bodyHeaders.putSingle("Content-Type", bodyMediaType.toString());
            if (bodyHeaders.getFirst("Content-Disposition") == null && bodyPart.getContentDisposition() != null) {
                bodyHeaders.putSingle("Content-Disposition", bodyPart.getContentDisposition().toString());
            }
            for (Map.Entry entry : bodyHeaders.entrySet()) {
                writer.write((String)entry.getKey());
                ((Writer)writer).write(58);
                boolean first = true;
                for (String value2 : (List)entry.getValue()) {
                    if (first) {
                        ((Writer)writer).write(32);
                        first = false;
                    } else {
                        ((Writer)writer).write(44);
                    }
                    writer.write(value2);
                }
                writer.write("\r\n");
            }
            writer.write("\r\n");
            ((Writer)writer).flush();
            Object bodyEntity = bodyPart.getEntity();
            if (bodyEntity == null) {
                throw new IllegalArgumentException(LocalizationMessages.MISSING_ENTITY_OF_BODY_PART(bodyMediaType));
            }
            Class<Object> bodyClass = bodyEntity.getClass();
            if (bodyEntity instanceof BodyPartEntity) {
                bodyClass = InputStream.class;
                bodyEntity = ((BodyPartEntity)bodyEntity).getInputStream();
            }
            Type bodyType = bodyClass;
            if (GenericEntity.class.isInstance(bodyEntity)) {
                bodyClass = ((GenericEntity)bodyEntity).getRawType();
                bodyType = ((GenericEntity)bodyEntity).getType();
                bodyEntity = ((GenericEntity)bodyEntity).getEntity();
            }
            if ((bodyWriter = this.providers.getMessageBodyWriter(bodyClass, bodyType, EMPTY_ANNOTATIONS, bodyMediaType)) == null) {
                throw new IllegalArgumentException(LocalizationMessages.NO_AVAILABLE_MBW(bodyClass, bodyMediaType));
            }
            bodyWriter.writeTo(bodyEntity, bodyClass, bodyClass, EMPTY_ANNOTATIONS, bodyMediaType, bodyHeaders, stream);
        }
        writer.write("\r\n--");
        writer.write(boundaryString);
        writer.write("--\r\n");
        ((Writer)writer).flush();
    }
}

