/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver;

import fr.brouillard.oss.jgitver.JGitverConfiguration;
import fr.brouillard.oss.jgitver.cfg.Configuration;
import fr.brouillard.oss.jgitver.cfg.ConfigurationLoader;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=JGitverConfiguration.class, instantiationStrategy="singleton")
public class JGitverConfigurationComponent
implements JGitverConfiguration {
    @Requirement
    private LegacySupport legacySupport = null;
    @Requirement
    private Logger logger = null;
    private volatile Configuration configuration;
    private List<File> excludedDirectories = new LinkedList<File>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration getConfiguration() throws MavenExecutionException {
        if (this.configuration == null) {
            JGitverConfigurationComponent jGitverConfigurationComponent = this;
            synchronized (jGitverConfigurationComponent) {
                if (this.configuration == null) {
                    MavenSession mavenSession = this.legacySupport.getSession();
                    File rootDirectory = mavenSession.getRequest().getMultiModuleProjectDirectory();
                    this.logger.debug("using jgitver on directory: " + rootDirectory);
                    this.configuration = ConfigurationLoader.loadFromRoot(rootDirectory, this.logger);
                    this.initFromRootDirectory(rootDirectory, this.configuration.exclusions);
                }
            }
        }
        return this.configuration;
    }

    private void initFromRootDirectory(File rootDirectory, List<String> exclusions) {
        exclusions.stream().map(dirName -> new File(rootDirectory, (String)dirName)).forEach(dir -> {
            this.excludedDirectories.add((File)dir);
            this.logger.debug("ignoring directory (& sub dirs): " + dir);
        });
    }

    @Override
    public boolean ignore(File pomFile) throws IOException {
        for (File excludedDir : this.excludedDirectories) {
            if (!StringUtils.containsIgnoreCase((CharSequence)pomFile.getParentFile().getCanonicalFile().getCanonicalPath(), (CharSequence)excludedDir.getCanonicalPath())) continue;
            return true;
        }
        return false;
    }
}

