/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.cfg;

import org.codehaus.plexus.logging.AbstractLogger;
import org.codehaus.plexus.logging.Logger;

public class InMemoryLogger
extends AbstractLogger {
    private final StringBuffer sb;
    private final String ls = System.getProperty("line.separator");

    public InMemoryLogger() {
        super(0, "InMemory");
        this.sb = new StringBuffer();
    }

    public void debug(String message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.log(message, throwable);
        }
    }

    public void info(String message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.log(message, throwable);
        }
    }

    public void warn(String message, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.log(message, throwable);
        }
    }

    public void error(String message, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.log(message, throwable);
        }
    }

    public void fatalError(String message, Throwable throwable) {
        if (this.isFatalErrorEnabled()) {
            this.log(message, throwable);
        }
    }

    public Logger getChildLogger(String name) {
        return this;
    }

    private synchronized void log(String message, Throwable throwable) {
        this.sb.append(message).append(this.ls);
        if (throwable != null) {
            this.sb.append("    ").append(throwable.toString());
        }
    }

    public String toString() {
        return this.sb.toString();
    }
}

