/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import fr.brouillard.oss.jgitver.BranchingPolicy;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

public class VersionNamingConfiguration {
    public static final Pattern DEFAULT_FIND_TAG_VERSION_PATTERN = Pattern.compile("v?([0-9]+(?:\\.[0-9]+){0,2}(?:-[a-zA-Z0-9\\-_]+)?)");
    private static final String EXTRACT_TAG_VERSION_PATTERN = "$1";
    private Pattern searchPattern;
    private List<BranchingPolicy> branchPolicies;

    public VersionNamingConfiguration(BranchingPolicy ... policies) {
        this.branchPolicies = new LinkedList<BranchingPolicy>(Arrays.asList(policies));
        this.searchPattern = DEFAULT_FIND_TAG_VERSION_PATTERN;
    }

    public VersionNamingConfiguration(Pattern searchVersionPattern, BranchingPolicy ... policies) {
        this.branchPolicies = new LinkedList<BranchingPolicy>(Arrays.asList(policies));
        this.searchPattern = searchVersionPattern;
    }

    protected Pattern getSearchPattern() {
        return this.searchPattern;
    }

    protected String getReplaceVersionRegex() {
        return EXTRACT_TAG_VERSION_PATTERN;
    }

    public String extractVersionFrom(String tagName) {
        return this.searchPattern.matcher(tagName).replaceAll(this.getReplaceVersionRegex());
    }

    public Optional<String> branchQualifier(String branch) {
        for (BranchingPolicy bPolicy : this.branchPolicies) {
            if (!bPolicy.appliesOn(branch)) continue;
            return bPolicy.qualifier(branch);
        }
        return Optional.empty();
    }
}

