/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl.pattern;

import fr.brouillard.oss.jgitver.Version;
import fr.brouillard.oss.jgitver.impl.pattern.AutoSeparatorProvider;
import fr.brouillard.oss.jgitver.impl.pattern.Mode;
import fr.brouillard.oss.jgitver.impl.pattern.Prefix;
import fr.brouillard.oss.jgitver.impl.pattern.VersionGrammarDefinition;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.petitparser.parser.Parser;

public class VersionPatternGrammarDefinition
extends VersionGrammarDefinition {
    private AutoSeparatorProvider separatorProvider;

    public VersionPatternGrammarDefinition(Version version, Function<String, Optional<String>> env, Function<String, Optional<String>> sys, Function<Metadatas, Optional<String>> meta) {
        this.resetSeparatorProvider();
        this.action("pattern", elements -> {
            String computedVersion = elements.stream().map(Object::toString).collect(Collectors.joining());
            return Version.parse(computedVersion);
        });
        this.action("pattern_element", o -> o);
        this.action("delimitedPlaceholder", o -> o);
        this.action("placeholder", o -> o);
        this.action("withPrefixPlaceholder", elements -> {
            Prefix p = (Prefix)elements.get(0);
            Optional value = (Optional)elements.get(1);
            Optional<String> result = p.apply(value);
            result.ifPresent(ignore -> this.getSeparatorProvider().next());
            return result;
        });
        this.action("chars", o -> o);
        this.action("prefix_placeholder", o -> o);
        this.action("fixed_prefix_placeholder", elements -> {
            this.getSeparatorProvider().endVersion();
            String prefix = (String)elements.get(0);
            Mode mode = (Mode)((Object)((Object)elements.get(1)));
            return new Prefix(mode, prefix);
        });
        this.action("mandatory_prefix_placeholder", o -> o);
        this.action("optional_prefix_placeholder", o -> o);
        this.action("auto_prefix_placeholder", ignore -> new Prefix(Mode.OPTIONAL, () -> this.getSeparatorProvider().currentSeparator()));
        this.action("meta", s -> {
            try {
                Metadatas m = Metadatas.valueOf(s);
                return (Optional)meta.apply(m);
            }
            catch (IllegalArgumentException iae) {
                return Optional.empty();
            }
        });
        this.action("sys", s -> (Optional)sys.apply((String)s));
        this.action("env", s -> (Optional)env.apply((String)s));
        this.action("full_version", o -> {
            this.getSeparatorProvider().major();
            this.getSeparatorProvider().minor();
            this.getSeparatorProvider().patch();
            this.getSeparatorProvider().next();
            return Optional.of(String.format("%s.%s.%s", version.getMajor(), version.getMinor(), version.getPatch()));
        });
        this.action("major_version", o -> {
            this.getSeparatorProvider().major();
            return Optional.of("" + version.getMajor());
        });
        this.action("minor_version", o -> {
            this.getSeparatorProvider().minor();
            return Optional.of("" + version.getMinor());
        });
        this.action("patch_version", o -> {
            this.getSeparatorProvider().patch();
            return Optional.of("" + version.getPatch());
        });
        this.action("inner_placeholder", o -> o);
        this.action("placeholder", o -> o.orElse(""));
    }

    public Parser build() {
        this.resetSeparatorProvider();
        return super.build();
    }

    public void resetSeparatorProvider() {
        this.separatorProvider = new AutoSeparatorProvider();
    }

    private AutoSeparatorProvider getSeparatorProvider() {
        return this.separatorProvider;
    }
}

