/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.cli;

import fr.brouillard.oss.jgitver.BranchingPolicy;
import fr.brouillard.oss.jgitver.GitVersionCalculator;
import fr.brouillard.oss.jgitver.JGitverProperties;
import fr.brouillard.oss.jgitver.cli.Options;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import picocli.CommandLine;

public class RunnableCLI {
    private static final String ALL_METADATAS = "ALL";

    public static void main(String[] args) {
        System.exit(RunnableCLI.execute(args, System.out, System.err));
    }

    static int execute(String[] args, PrintStream normal, PrintStream error) {
        Options opts = new Options();
        CommandLine cli = new CommandLine((Object)opts);
        try {
            cli.parseArgs(args);
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            CommandLine.usage((Object)new Options(), (PrintStream)error);
            return 1;
        }
        if (cli.isVersionHelpRequested()) {
            new CommandLine((Object)new Options()).printVersionHelp(normal, CommandLine.Help.Ansi.AUTO, new Object[]{JGitverProperties.getVersion(), JGitverProperties.getSHA1()});
            return 2;
        }
        if (cli.isUsageHelpRequested()) {
            CommandLine.usage((Object)new Options(), (PrintStream)normal);
            return 3;
        }
        GitVersionCalculator gvc = GitVersionCalculator.location(opts.directory);
        gvc.setUseDistance(opts.useDistance);
        gvc.setAutoIncrementPatch(opts.autoIncrementPatch);
        gvc.setUseDirty(opts.useDirty);
        gvc.setForceComputation(opts.forceComputation);
        gvc.setUseLongFormat(opts.useLongFormat);
        gvc.setUseGitCommitId(opts.useGitCommitId);
        if (opts.useGitCommitId) {
            gvc.setGitCommitIdLength(opts.gitCommitIdLength);
        }
        gvc.setUseGitCommitTimestamp(opts.useGitCommitTimestamp);
        gvc.setStrategy(opts.strategy);
        if (opts.pattern != null) {
            gvc.setFindTagVersionPattern(opts.pattern);
        }
        gvc.setLookupPolicy(opts.policy);
        if (opts.qualifierBranchPolicies != null) {
            gvc.setQualifierBranchingPolicies(opts.qualifierBranchPolicies.stream().map(policy -> {
                if (policy.branchPolicyPattern == null) {
                    throw new IllegalArgumentException("Each usage of branchPolicyTransformation must have a branchPolicyPattern");
                }
                if (policy.branchPolicyTransformations != null && policy.branchPolicyTransformations.size() > 0) {
                    return new BranchingPolicy(policy.branchPolicyPattern, policy.branchPolicyTransformations.stream().map(Enum::name).collect(Collectors.toList()));
                }
                return new BranchingPolicy(policy.branchPolicyPattern);
            }).collect(Collectors.toList()));
        }
        if (opts.nonQualifierBranches != null) {
            gvc.setNonQualifierBranches(opts.nonQualifierBranches);
        }
        if (opts.versionPattern != null) {
            gvc.setVersionPattern(opts.versionPattern);
        }
        if (opts.tagVersionPattern != null) {
            gvc.setTagVersionPattern(opts.tagVersionPattern);
        }
        if (opts.metadatas == null) {
            normal.print(gvc.getVersion());
        } else {
            Stream<Metadatas> metadatas = ALL_METADATAS.equals(opts.metadatas) ? Arrays.stream(Metadatas.values()) : Arrays.stream(opts.metadatas.split(",")).map(Metadatas::valueOf);
            metadatas.forEach(m -> normal.println(String.format("%s=%s", m, gvc.meta((Metadatas)((Object)m)).orElse("No value found"))));
        }
        return 0;
    }
}

