/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import fr.brouillard.oss.jgitver.Version;
import fr.brouillard.oss.jgitver.impl.Commit;
import fr.brouillard.oss.jgitver.impl.GitUtils;
import fr.brouillard.oss.jgitver.impl.VersionCalculationException;
import fr.brouillard.oss.jgitver.impl.VersionNamingConfiguration;
import fr.brouillard.oss.jgitver.impl.VersionStrategy;
import fr.brouillard.oss.jgitver.metadata.MetadataRegistrar;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class MavenVersionStrategy
extends VersionStrategy<MavenVersionStrategy> {
    private boolean useDirty = false;
    private boolean forceComputation = false;

    public MavenVersionStrategy(VersionNamingConfiguration vnc, Repository repository, Git git, MetadataRegistrar metadatas) {
        super(vnc, repository, git, metadatas);
    }

    @Override
    public Version build(Commit head, List<Commit> parents) throws VersionCalculationException {
        try {
            Commit base = this.findVersionCommit(head, parents);
            Ref tagToUse = this.findTagToUse(head, base);
            Version baseVersion = this.getBaseVersionAndRegisterMetadata(base, tagToUse);
            boolean needSnapshot = true;
            boolean isDirty = GitUtils.isDirty(this.getGit());
            boolean isDetachedHead = GitUtils.isDetachedHead(this.getRepository());
            boolean isBaseCommitOnHead = this.isBaseCommitOnHead(head, base);
            boolean shouldComputeVersion = !isDetachedHead || isDirty || !isBaseCommitOnHead || this.forceComputation;
            this.getRegistrar().registerMetadata(Metadatas.BASE_COMMIT_ON_HEAD, "" + isBaseCommitOnHead);
            if (tagToUse != null) {
                boolean bl = needSnapshot = baseVersion.isSnapshot() || !isBaseCommitOnHead || !GitUtils.isAnnotated(tagToUse) || isDirty && !isDetachedHead || this.forceComputation;
            }
            if (shouldComputeVersion && (!isBaseCommitOnHead || isDirty && !isDetachedHead || this.forceComputation)) {
                if (GitUtils.isAnnotated(tagToUse) && !baseVersion.removeQualifier("SNAPSHOT").isQualified()) {
                    baseVersion = baseVersion.incrementPatch();
                }
                baseVersion = baseVersion.noQualifier();
            }
            if (!isDetachedHead) {
                String branch = this.getRepository().getBranch();
                baseVersion = this.enhanceVersionWithBranch(baseVersion, branch);
            } else {
                Optional<String> externalyProvidedBranchName = GitUtils.providedBranchName();
                if (externalyProvidedBranchName.isPresent()) {
                    baseVersion = this.enhanceVersionWithBranch(baseVersion, externalyProvidedBranchName.get());
                    this.getRegistrar().registerMetadata(Metadatas.PROVIDED_BRANCH_NAME, externalyProvidedBranchName.get());
                }
            }
            if (this.useDirty && isDirty) {
                baseVersion = baseVersion.addQualifier("dirty");
            }
            try (RevWalk walk = new RevWalk(this.getRepository());){
                RevCommit rc = walk.parseCommit((AnyObjectId)head.getGitObject());
                String commitTimestamp = GitUtils.getTimestamp(rc.getAuthorIdent().getWhen().toInstant());
                this.getRegistrar().registerMetadata(Metadatas.COMMIT_TIMESTAMP, commitTimestamp);
                String isoCommitTimestamp = GitUtils.getIsoTimestamp(rc.getAuthorIdent().getWhen().toInstant());
                this.getRegistrar().registerMetadata(Metadatas.COMMIT_ISO_TIMESTAMP, isoCommitTimestamp);
            }
            return needSnapshot ? baseVersion.removeQualifier("SNAPSHOT").addQualifier("SNAPSHOT") : baseVersion;
        }
        catch (Exception ex) {
            throw new VersionCalculationException("cannot compute version", ex);
        }
    }

    public MavenVersionStrategy setUseDirty(boolean useDirty) {
        return (MavenVersionStrategy)this.runAndGetSelf(() -> {
            this.useDirty = useDirty;
        });
    }

    public MavenVersionStrategy setForceComputation(boolean forceComputation) {
        return (MavenVersionStrategy)this.runAndGetSelf(() -> {
            this.forceComputation = forceComputation;
        });
    }
}

