/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovy.lang.MetaMethod;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import java.util.List;
import org.codehaus.groovy.classgen.BytecodeHelper;

public class ReflectorGenerator
implements Opcodes {
    private List methods;
    private ClassVisitor cw;
    private MethodVisitor cv;
    private BytecodeHelper helper = new BytecodeHelper(null);
    private String classInternalName;

    public ReflectorGenerator(List methods) {
        this.methods = methods;
    }

    public void generate(ClassVisitor cw, String className) {
        this.cw = cw;
        this.classInternalName = BytecodeHelper.getClassInternalName(className);
        cw.visit(47, 33, this.classInternalName, null, "org/codehaus/groovy/runtime/Reflector", null);
        this.cv = cw.visitMethod(1, "<init>", "()V", null, null);
        this.cv.visitVarInsn(25, 0);
        this.cv.visitMethodInsn(183, "org/codehaus/groovy/runtime/Reflector", "<init>", "()V");
        this.cv.visitInsn(177);
        this.cv.visitMaxs(1, 1);
        this.generateInvokeMethod();
        cw.visitEnd();
    }

    protected void generateInvokeMethod() {
        MetaMethod method;
        int i;
        int methodCount = this.methods.size();
        this.cv = this.cw.visitMethod(1, "invoke", "(Lgroovy/lang/MetaMethod;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        this.helper = new BytecodeHelper(this.cv);
        this.cv.visitVarInsn(25, 1);
        this.cv.visitMethodInsn(182, "groovy/lang/MetaMethod", "getMethodIndex", "()I");
        Label defaultLabel = new Label();
        Label[] labels = new Label[methodCount];
        int[] indices = new int[methodCount];
        for (i = 0; i < methodCount; ++i) {
            labels[i] = new Label();
            method = (MetaMethod)this.methods.get(i);
            method.setMethodIndex(i + 1);
            indices[i] = method.getMethodIndex();
        }
        this.cv.visitLookupSwitchInsn(defaultLabel, indices, labels);
        for (i = 0; i < methodCount; ++i) {
            this.cv.visitLabel(labels[i]);
            method = (MetaMethod)this.methods.get(i);
            this.invokeMethod(method);
            if (method.getReturnType() == Void.TYPE) {
                this.cv.visitInsn(1);
            }
            this.cv.visitInsn(176);
        }
        this.cv.visitLabel(defaultLabel);
        this.cv.visitVarInsn(25, 0);
        this.cv.visitVarInsn(25, 1);
        this.cv.visitVarInsn(25, 2);
        this.cv.visitVarInsn(25, 3);
        this.cv.visitMethodInsn(182, this.classInternalName, "noSuchMethod", "(Lgroovy/lang/MetaMethod;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
        this.cv.visitInsn(176);
        this.cv.visitMaxs(4, 4);
    }

    protected void invokeMethod(MetaMethod method) {
        Class ownerClass = method.getInterfaceClass();
        boolean useInterface = false;
        if (ownerClass == null) {
            ownerClass = method.getDeclaringClass();
        } else {
            useInterface = true;
        }
        String type = BytecodeHelper.getClassInternalName(ownerClass.getName());
        String descriptor = BytecodeHelper.getMethodDescriptor(method.getReturnType(), method.getParameterTypes());
        if (method.isStatic()) {
            this.loadParameters(method, 3);
            this.cv.visitMethodInsn(184, type, method.getName(), descriptor);
        } else {
            this.cv.visitVarInsn(25, 2);
            this.helper.doCast(ownerClass);
            this.loadParameters(method, 3);
            this.cv.visitMethodInsn(useInterface ? 185 : 182, type, method.getName(), descriptor);
        }
        this.helper.box(method.getReturnType());
    }

    protected void loadParameters(MetaMethod method, int argumentIndex) {
        Class[] parameters = method.getParameterTypes();
        int size = parameters.length;
        for (int i = 0; i < size; ++i) {
            this.cv.visitVarInsn(25, argumentIndex);
            this.helper.pushConstant(i);
            this.cv.visitInsn(50);
            Class type = parameters[i];
            if (type.isPrimitive()) {
                this.helper.unbox(type);
                continue;
            }
            this.helper.doCast(type.getName());
        }
    }
}

