/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.Tuple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.InvokerHelper;

public class ScriptBytecodeAdapter {
    public static final Object[] EMPTY_ARGS = new Object[0];

    private static Object unwrap(GroovyRuntimeException gre) throws Throwable {
        Throwable th = gre;
        if (th.getCause() != null && th.getCause() != gre) {
            th = th.getCause();
        }
        if (th != gre && th instanceof GroovyRuntimeException) {
            ScriptBytecodeAdapter.unwrap(th);
        }
        throw th;
    }

    public static Object invokeMethod(Object object, String methodName, Object arguments) throws Throwable {
        try {
            return InvokerHelper.invokeMethod(object, methodName, arguments);
        }
        catch (GroovyRuntimeException gre) {
            return ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Object invokeMethodSafe(Object object, String methodName, Object arguments) throws Throwable {
        if (object != null) {
            return ScriptBytecodeAdapter.invokeMethod(object, methodName, arguments);
        }
        return null;
    }

    public static Object invokeMethodSpreadSafe(Object object, String methodName, Object arguments) throws Throwable {
        if (object != null) {
            if (object instanceof List) {
                List list = (List)object;
                ArrayList<Object> answer = new ArrayList<Object>();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    answer.add(ScriptBytecodeAdapter.invokeMethodSafe(it.next(), methodName, arguments));
                }
                return answer;
            }
            return ScriptBytecodeAdapter.invokeMethodSafe(object, methodName, arguments);
        }
        return null;
    }

    public static Object invokeStaticMethod(String type, String methodName, Object arguments) throws Throwable {
        try {
            return InvokerHelper.invokeStaticMethod(type, methodName, arguments);
        }
        catch (GroovyRuntimeException gre) {
            return ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Object invokeConstructor(String type, Object arguments) throws Throwable {
        try {
            return InvokerHelper.invokeConstructor(type, arguments);
        }
        catch (GroovyRuntimeException gre) {
            return ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Object invokeConstructorOf(Class type, Object arguments) throws Throwable {
        try {
            return InvokerHelper.invokeConstructorOf(type, arguments);
        }
        catch (GroovyRuntimeException gre) {
            return ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Object invokeNoArgumentsConstructorOf(Class type) throws Throwable {
        return ScriptBytecodeAdapter.invokeConstructorOf(type, EMPTY_ARGS);
    }

    public static Object invokeClosure(Object closure, Object arguments) throws Throwable {
        return ScriptBytecodeAdapter.invokeMethod(closure, "doCall", arguments);
    }

    public static Object invokeSuperMethod(Object object, String methodName, Object arguments) throws Throwable {
        try {
            return InvokerHelper.invokeSuperMethod(object, methodName, arguments);
        }
        catch (GroovyRuntimeException gre) {
            return ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Object invokeNoArgumentsMethod(Object object, String methodName) throws Throwable {
        return ScriptBytecodeAdapter.invokeMethod(object, methodName, EMPTY_ARGS);
    }

    public static Object invokeNoArgumentsMethodSafe(Object object, String methodName) throws Throwable {
        if (object != null) {
            return ScriptBytecodeAdapter.invokeNoArgumentsMethod(object, methodName);
        }
        return null;
    }

    public static Object invokeNoArgumentsMethodSpreadSafe(Object object, String methodName) throws Throwable {
        if (object != null) {
            if (object instanceof List) {
                List list = (List)object;
                ArrayList<Object> answer = new ArrayList<Object>();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    answer.add(ScriptBytecodeAdapter.invokeNoArgumentsMethod(it.next(), methodName));
                }
                return answer;
            }
            return ScriptBytecodeAdapter.invokeNoArgumentsMethod(object, methodName);
        }
        return null;
    }

    public static Object invokeStaticNoArgumentsMethod(String type, String methodName) throws Throwable {
        return ScriptBytecodeAdapter.invokeStaticMethod(type, methodName, EMPTY_ARGS);
    }

    public static int asInt(Object value) throws Throwable {
        try {
            return InvokerHelper.asInt(value);
        }
        catch (GroovyRuntimeException gre) {
            ScriptBytecodeAdapter.unwrap(gre);
            return -1;
        }
    }

    public static Object asType(Object object, Class type) throws Throwable {
        try {
            return InvokerHelper.asType(object, type);
        }
        catch (GroovyRuntimeException gre) {
            return ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Object getAttribute(Object object, String attribute) throws Throwable {
        try {
            return InvokerHelper.getAttribute(object, attribute);
        }
        catch (GroovyRuntimeException gre) {
            return ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Object getAttributeSafe(Object object, String attribute) throws Throwable {
        if (object != null) {
            return ScriptBytecodeAdapter.getAttribute(object, attribute);
        }
        return null;
    }

    public static Object getAttributeSpreadSafe(Object object, String attribute) throws Throwable {
        if (object != null) {
            if (object instanceof List) {
                List list = (List)object;
                ArrayList<Object> answer = new ArrayList<Object>();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    answer.add(ScriptBytecodeAdapter.getAttributeSafe(it.next(), attribute));
                }
                return answer;
            }
            return ScriptBytecodeAdapter.getAttributeSafe(object, attribute);
        }
        return null;
    }

    public static void setAttribute(Object object, String attribute, Object newValue) throws Throwable {
        try {
            InvokerHelper.setAttribute(object, attribute, newValue);
        }
        catch (GroovyRuntimeException gre) {
            ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static void setAttribute2(Object newValue, Object object, String property) throws Throwable {
        ScriptBytecodeAdapter.setAttribute(object, property, newValue);
    }

    public static void setAttributeSafe2(Object newValue, Object object, String property) throws Throwable {
        ScriptBytecodeAdapter.setAttribute2(newValue, object, property);
    }

    public static Object getProperty(Object object, String property) throws Throwable {
        try {
            return InvokerHelper.getProperty(object, property);
        }
        catch (GroovyRuntimeException gre) {
            return ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Object getPropertySafe(Object object, String property) throws Throwable {
        if (object != null) {
            return ScriptBytecodeAdapter.getProperty(object, property);
        }
        return null;
    }

    public static Object getPropertySpreadSafe(Object object, String property) throws Throwable {
        if (object != null) {
            if (object instanceof List) {
                List list = (List)object;
                ArrayList<Object> answer = new ArrayList<Object>();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    answer.add(ScriptBytecodeAdapter.getPropertySafe(it.next(), property));
                }
                return answer;
            }
            return ScriptBytecodeAdapter.getPropertySafe(object, property);
        }
        return null;
    }

    public static void setProperty(Object object, String property, Object newValue) throws Throwable {
        try {
            InvokerHelper.setProperty(object, property, newValue);
        }
        catch (GroovyRuntimeException gre) {
            ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static void setProperty2(Object newValue, Object object, String property) throws Throwable {
        ScriptBytecodeAdapter.setProperty(object, property, newValue);
    }

    public static void setPropertySafe2(Object newValue, Object object, String property) throws Throwable {
        ScriptBytecodeAdapter.setProperty2(newValue, object, property);
    }

    public static void setGroovyObjectProperty(Object newValue, GroovyObject object, String property) throws Throwable {
        try {
            object.setProperty(property, newValue);
        }
        catch (GroovyRuntimeException gre) {
            ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Object getGroovyObjectProperty(GroovyObject object, String property) throws Throwable {
        try {
            return object.getProperty(property);
        }
        catch (GroovyRuntimeException gre) {
            return ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Closure getMethodPointer(Object object, String methodName) {
        return InvokerHelper.getMethodPointer(object, methodName);
    }

    public static Iterator asIterator(Object collection) throws Throwable {
        try {
            return InvokerHelper.asIterator(collection);
        }
        catch (GroovyRuntimeException gre) {
            return (Iterator)ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static boolean asBool(Object object) throws Throwable {
        try {
            return InvokerHelper.asBool(object);
        }
        catch (GroovyRuntimeException gre) {
            ScriptBytecodeAdapter.unwrap(gre);
            return false;
        }
    }

    public static boolean notBoolean(boolean bool) {
        return !bool;
    }

    public static boolean notObject(Object object) throws Throwable {
        return !ScriptBytecodeAdapter.asBool(object);
    }

    public static Pattern regexPattern(Object regex) throws Throwable {
        try {
            return InvokerHelper.regexPattern(regex);
        }
        catch (GroovyRuntimeException gre) {
            return (Pattern)ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Object spreadList(Object value) throws Throwable {
        try {
            return InvokerHelper.spreadList(value);
        }
        catch (GroovyRuntimeException gre) {
            return ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Object spreadMap(Object value) throws Throwable {
        try {
            return InvokerHelper.spreadMap(value);
        }
        catch (GroovyRuntimeException gre) {
            return ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Object negate(Object value) throws Throwable {
        try {
            return InvokerHelper.negate(value);
        }
        catch (GroovyRuntimeException gre) {
            return ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Object bitNegate(Object value) throws Throwable {
        try {
            return InvokerHelper.bitNegate(value);
        }
        catch (GroovyRuntimeException gre) {
            return ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Object[] convertPrimitiveArray(Object a, Class type) throws Throwable {
        try {
            return InvokerHelper.convertPrimitiveArray(a, type);
        }
        catch (GroovyRuntimeException gre) {
            return (Object[])ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Object convertToPrimitiveArray(Object a, Class type) throws Throwable {
        try {
            return InvokerHelper.convertToPrimitiveArray(a, type);
        }
        catch (GroovyRuntimeException gre) {
            return ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static boolean compareIdentical(Object left, Object right) {
        return left == right;
    }

    public static boolean compareEqual(Object left, Object right) throws Throwable {
        try {
            return InvokerHelper.compareEqual(left, right);
        }
        catch (GroovyRuntimeException gre) {
            ScriptBytecodeAdapter.unwrap(gre);
            return false;
        }
    }

    public static boolean compareNotEqual(Object left, Object right) throws Throwable {
        return !ScriptBytecodeAdapter.compareEqual(left, right);
    }

    public static Integer compareTo(Object left, Object right) throws Throwable {
        try {
            return InvokerHelper.compareTo(left, right);
        }
        catch (GroovyRuntimeException gre) {
            return (Integer)ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static Matcher findRegex(Object left, Object right) throws Throwable {
        try {
            return InvokerHelper.findRegex(left, right);
        }
        catch (GroovyRuntimeException gre) {
            return (Matcher)ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static boolean matchRegex(Object left, Object right) throws Throwable {
        try {
            return InvokerHelper.matchRegex(left, right);
        }
        catch (GroovyRuntimeException gre) {
            ScriptBytecodeAdapter.unwrap(gre);
            return false;
        }
    }

    public static boolean compareLessThan(Object left, Object right) throws Throwable {
        return ScriptBytecodeAdapter.compareTo(left, right) < 0;
    }

    public static boolean compareLessThanEqual(Object left, Object right) throws Throwable {
        return ScriptBytecodeAdapter.compareTo(left, right) <= 0;
    }

    public static boolean compareGreaterThan(Object left, Object right) throws Throwable {
        return ScriptBytecodeAdapter.compareTo(left, right) > 0;
    }

    public static boolean compareGreaterThanEqual(Object left, Object right) throws Throwable {
        return ScriptBytecodeAdapter.compareTo(left, right) >= 0;
    }

    public static boolean isCase(Object switchValue, Object caseExpression) throws Throwable {
        return ScriptBytecodeAdapter.asBool(ScriptBytecodeAdapter.invokeMethod(caseExpression, "isCase", new Object[]{switchValue}));
    }

    public static Tuple createTuple(Object[] array) throws Throwable {
        return new Tuple(array);
    }

    public static List createList(Object[] values) throws Throwable {
        return InvokerHelper.createList(values);
    }

    public static Map createMap(Object[] values) throws Throwable {
        return InvokerHelper.createMap(values);
    }

    public static List createRange(Object from, Object to, boolean inclusive) throws Throwable {
        try {
            return InvokerHelper.createRange(from, to, inclusive);
        }
        catch (GroovyRuntimeException gre) {
            return (List)ScriptBytecodeAdapter.unwrap(gre);
        }
    }

    public static void assertFailed(Object expression, Object message) {
        InvokerHelper.assertFailed(expression, message);
    }

    public static Object box(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object box(byte value) {
        return new Byte(value);
    }

    public static Object box(char value) {
        return new Character(value);
    }

    public static Object box(short value) {
        return new Short(value);
    }

    public static Object box(int value) {
        return ScriptBytecodeAdapter.integerValue(value);
    }

    public static Object box(long value) {
        return new Long(value);
    }

    public static Object box(float value) {
        return new Float(value);
    }

    public static Object box(double value) {
        return new Double(value);
    }

    public static Integer integerValue(int v) {
        return InvokerHelper.integerValue(v);
    }

    public static byte byteUnbox(Object value) throws Throwable {
        Number n = (Number)ScriptBytecodeAdapter.asType(value, Byte.class);
        return n.byteValue();
    }

    public static char charUnbox(Object value) throws Throwable {
        Character n = (Character)ScriptBytecodeAdapter.asType(value, Character.class);
        return n.charValue();
    }

    public static short shortUnbox(Object value) throws Throwable {
        Number n = (Number)ScriptBytecodeAdapter.asType(value, Short.class);
        return n.shortValue();
    }

    public static int intUnbox(Object value) throws Throwable {
        Number n = (Number)ScriptBytecodeAdapter.asType(value, Integer.class);
        return n.intValue();
    }

    public static boolean booleanUnbox(Object value) throws Throwable {
        Boolean n = (Boolean)ScriptBytecodeAdapter.asType(value, Boolean.class);
        return n;
    }

    public static long longUnbox(Object value) throws Throwable {
        Number n = (Number)ScriptBytecodeAdapter.asType(value, Long.class);
        return n.longValue();
    }

    public static float floatUnbox(Object value) throws Throwable {
        Number n = (Number)ScriptBytecodeAdapter.asType(value, Float.class);
        return n.floatValue();
    }

    public static double doubleUnbox(Object value) throws Throwable {
        Number n = (Number)ScriptBytecodeAdapter.asType(value, Double.class);
        return n.doubleValue();
    }

    public static MetaClass getMetaClass(Object object) {
        return InvokerHelper.getMetaClass(object);
    }
}

