/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.EntityAction;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheKey;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PreDeleteEvent;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityDeleteAction
extends EntityAction {
    private final Object version;
    private CacheConcurrencyStrategy.SoftLock lock;
    private final boolean isCascadeDeleteEnabled;
    private final Object[] state;

    public EntityDeleteAction(Serializable id, Object[] state, Object version, Object instance, EntityPersister persister, boolean isCascadeDeleteEnabled, SessionImplementor session) {
        super(session, id, instance, persister);
        this.version = version;
        this.isCascadeDeleteEnabled = isCascadeDeleteEnabled;
        this.state = state;
    }

    public void execute() throws HibernateException {
        PersistenceContext persistenceContext;
        EntityEntry entry;
        CacheKey ck;
        Serializable id = this.getId();
        EntityPersister persister = this.getPersister();
        SessionImplementor session = this.getSession();
        Object instance = this.getInstance();
        PreDeleteEvent preEvent = new PreDeleteEvent(instance, id, this.state, persister, session);
        boolean veto = session.getListeners().getPreDeleteEventListener().onPreDelete(preEvent);
        if (persister.hasCache()) {
            ck = new CacheKey(id, this.getPersister().getIdentifierType(), persister.getRootEntityName(), session.getEntityMode(), session.getFactory());
            this.lock = persister.getCache().lock(ck, this.version);
        } else {
            ck = null;
        }
        if (!this.isCascadeDeleteEnabled && !veto) {
            persister.delete(id, this.version, instance, session);
        }
        if ((entry = (persistenceContext = session.getPersistenceContext()).removeEntry(instance)) == null) {
            throw new AssertionFailure("possible nonthreadsafe access to session");
        }
        persistenceContext.setEntryStatus(entry, Status.GONE);
        entry.setExistsInDatabase(false);
        EntityKey key = new EntityKey(entry.getId(), entry.getPersister(), session.getEntityMode());
        persistenceContext.removeEntity(key);
        persistenceContext.removeProxy(key);
        if (persister.hasCache()) {
            persister.getCache().evict(ck);
        }
        PostDeleteEvent postEvent = new PostDeleteEvent(instance, id, this.state, this.getPersister(), session);
        session.getListeners().getPostDeleteEventListener().onPostDelete(postEvent);
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled() && !veto) {
            this.getSession().getFactory().getStatisticsImplementor().deleteEntity(this.getPersister().getEntityName());
        }
    }

    public void afterTransactionCompletion(boolean success) throws HibernateException {
        CacheKey ck = new CacheKey(this.getId(), this.getPersister().getIdentifierType(), this.getPersister().getRootEntityName(), this.getSession().getEntityMode(), this.getSession().getFactory());
        if (this.getPersister().hasCache()) {
            this.getPersister().getCache().release(ck, this.lock);
        }
    }
}

