/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.AbstractPostInsertGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.type.Type;

public class SelectGenerator
extends AbstractPostInsertGenerator
implements Configurable {
    private String uniqueKeyPropertyName;
    private Type idType;
    private String entityName;

    public void configure(Type type, Properties params, Dialect d) throws MappingException {
        this.uniqueKeyPropertyName = params.getProperty("key");
        this.entityName = params.getProperty("entity_name");
        this.idType = type;
    }

    protected String getSQL(PostInsertIdentityPersister persister) {
        return persister.getSelectByUniqueKeyString(this.uniqueKeyPropertyName);
    }

    protected void bindParameters(SessionImplementor session, PreparedStatement ps, Object object, PostInsertIdentityPersister persister) throws SQLException {
        Type uniqueKeyPropertyType = session.getSessionFactory().getClassMetadata(this.entityName).getPropertyType(this.uniqueKeyPropertyName);
        Object uniqueKeyValue = persister.getPropertyValue(object, this.uniqueKeyPropertyName, session.getEntityMode());
        uniqueKeyPropertyType.nullSafeSet(ps, uniqueKeyValue, 1, session);
    }

    protected Serializable getResult(SessionImplementor session, ResultSet rs, Object object, PostInsertIdentityPersister persister) throws SQLException {
        if (!rs.next()) {
            throw new IdentifierGenerationException("the inserted row could not be located by the unique key: " + this.uniqueKeyPropertyName);
        }
        return (Serializable)this.idType.nullSafeGet(rs, persister.getRootTableKeyColumnNames(), session, object);
    }
}

