/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.xsd;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import jlibs.core.graph.Filter;
import jlibs.core.graph.Navigator;
import jlibs.core.graph.Path;
import jlibs.core.graph.Processor;
import jlibs.core.graph.Walker;
import jlibs.core.graph.WalkerUtil;
import jlibs.core.graph.navigators.FilteredTreeNavigator;
import jlibs.core.graph.walkers.PreorderWalker;
import jlibs.core.net.URLUtil;
import jlibs.xml.Namespaces;
import jlibs.xml.sax.SAXUtil;
import jlibs.xml.sax.XMLDocument;
import jlibs.xml.sax.helpers.MyNamespaceSupport;
import jlibs.xml.xsd.XSNavigator;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSNamespaceItemList;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSUtil {
    private static final RuntimeException STOP_SEARCHING = new RuntimeException("STOP_SEARCHING");

    public static MyNamespaceSupport createNamespaceSupport(XSModel model) {
        MyNamespaceSupport nsSupport = new MyNamespaceSupport();
        StringList list = model.getNamespaces();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i) == null) continue;
            nsSupport.declarePrefix(list.item(i));
        }
        return nsSupport;
    }

    public static QName getQName(XSObject obj) {
        return XSUtil.getQName(obj, null);
    }

    public static QName getQName(XSObject obj, MyNamespaceSupport nsSupport) {
        if (obj instanceof XSAttributeUse) {
            obj = ((XSAttributeUse)obj).getAttrDeclaration();
        }
        if (obj.getName() == null) {
            return new QName("");
        }
        String ns = obj.getNamespace() == null ? "" : obj.getNamespace();
        String prefix = nsSupport == null || ns.isEmpty() && obj instanceof XSAttributeDeclaration ? "" : nsSupport.findPrefix(ns);
        return new QName(ns, obj.getName(), prefix);
    }

    public static List<XSComplexTypeDefinition> getSubTypes(XSModel xsModel, XSComplexTypeDefinition complexType) {
        ArrayList<XSComplexTypeDefinition> subTypes = new ArrayList<XSComplexTypeDefinition>();
        XSNamedMap namedMap = xsModel.getComponents((short)3);
        XSObject anyType = namedMap.itemByName("http://www.w3.org/2001/XMLSchema", "anyType");
        for (int i = 0; i < namedMap.getLength(); ++i) {
            XSComplexTypeDefinition complexItem;
            XSObject item = namedMap.item(i);
            if (!(item instanceof XSComplexTypeDefinition) || (complexItem = (XSComplexTypeDefinition)item).getAbstract()) continue;
            while ((complexItem = (XSComplexTypeDefinition)complexItem.getBaseType()) != anyType && complexItem != complexType) {
            }
            if (complexItem != complexType) continue;
            subTypes.add((XSComplexTypeDefinition)item);
        }
        return subTypes;
    }

    public static List<XSElementDeclaration> guessRootElements(final XSModel model) {
        XSNamedMap components = model.getComponents((short)2);
        if (components.getLength() == 0) {
            return Collections.emptyList();
        }
        final ArrayList<XSElementDeclaration> elements = new ArrayList<XSElementDeclaration>(components.getLength());
        for (int i = 0; i < components.getLength(); ++i) {
            XSElementDeclaration elem = (XSElementDeclaration)components.item(i);
            if (elem.getAbstract()) continue;
            elements.add(elem);
        }
        Filter filter = new Filter(){

            public boolean select(Object elem) {
                return elem instanceof XSModel || elem instanceof XSElementDeclaration;
            }
        };
        FilteredTreeNavigator navigator = new FilteredTreeNavigator((Navigator)new XSNavigator(), filter);
        WalkerUtil.walk((Walker)new PreorderWalker((Object)model, (Navigator)navigator), (Processor)new Processor<Object>(){

            public boolean preProcess(Object elem, Path path) {
                if (path.getRecursionDepth() > 0) {
                    return false;
                }
                if (elements.size() > 1 && path.getLength() > 2) {
                    XSElementDeclaration elemDecl = (XSElementDeclaration)elem;
                    if (elemDecl.getAbstract()) {
                        XSObjectList substitutionGroup = model.getSubstitutionGroup(elemDecl);
                        for (int i = 0; i < substitutionGroup.getLength(); ++i) {
                            elements.remove(substitutionGroup.item(i));
                            if (elements.size() != 1) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        elements.remove(elem);
                    }
                }
                return true;
            }

            public void postProcess(Object elem, Path path) {
            }
        });
        return elements;
    }

    public static List<String> getEnumeratedValues(XSSimpleTypeDefinition simpleType) {
        ArrayList<String> enums = new ArrayList<String>();
        XSObjectList facets = simpleType.getMultiValueFacets();
        if (facets != null) {
            for (int i = 0; i < facets.getLength(); ++i) {
                XSMultiValueFacet facet = (XSMultiValueFacet)facets.item(i);
                if (facet.getFacetKind() != 2048) continue;
                StringList values = facet.getLexicalFacetValues();
                for (int j = 0; j < values.getLength(); ++j) {
                    enums.add(values.item(j));
                }
            }
        }
        return enums;
    }

    public static XSNamespaceItem getNamespaceItem(XSModel schema, String namespace) {
        XSNamespaceItemList list = schema.getNamespaceItems();
        for (int i = 0; i < list.getLength(); ++i) {
            XSNamespaceItem item = list.item(i);
            String ns = item.getSchemaNamespace();
            if (ns == null) {
                ns = "";
            }
            if (!ns.equals(namespace)) continue;
            return item;
        }
        return null;
    }

    public static XSElementDeclaration findElementDeclaration(XSModel schema, final List<QName> xpath) {
        XSElementDeclaration[] declaration;
        block3: {
            XSNamespaceItem nsItem = XSUtil.getNamespaceItem(schema, xpath.get(0).getNamespaceURI());
            if (nsItem == null) {
                return null;
            }
            FilteredTreeNavigator navigator = new FilteredTreeNavigator((Navigator)new XSNavigator(), new Filter(){

                public boolean select(Object elem) {
                    return elem instanceof XSElementDeclaration;
                }
            });
            declaration = new XSElementDeclaration[1];
            PreorderWalker walker = new PreorderWalker((Object)nsItem, (Navigator)navigator);
            try {
                WalkerUtil.walk((Walker)walker, (Processor)new Processor(){
                    int i = 0;

                    public boolean preProcess(Object elem, Path path) {
                        if (path.getParentPath() != null) {
                            QName qname = XSUtil.getQName((XSObject)((XSElementDeclaration)elem));
                            if (qname.equals(xpath.get(this.i))) {
                                ++this.i;
                                if (this.i == xpath.size()) {
                                    declaration[0] = (XSElementDeclaration)elem;
                                    throw STOP_SEARCHING;
                                }
                                return true;
                            }
                            return false;
                        }
                        return true;
                    }

                    public void postProcess(Object elem, Path path) {
                    }
                });
            }
            catch (RuntimeException ex) {
                if (ex == STOP_SEARCHING) break block3;
                throw ex;
            }
        }
        return declaration[0];
    }

    public static XSAttributeDeclaration findAttributeDeclaration(XSModel schema, final List<QName> xpath) {
        XSAttributeDeclaration[] declaration;
        block3: {
            XSNamespaceItem nsItem = XSUtil.getNamespaceItem(schema, xpath.get(0).getNamespaceURI());
            if (nsItem == null) {
                return null;
            }
            FilteredTreeNavigator navigator = new FilteredTreeNavigator((Navigator)new XSNavigator(), new Filter(){

                public boolean select(Object elem) {
                    return elem instanceof XSElementDeclaration || elem instanceof XSAttributeUse;
                }
            });
            declaration = new XSAttributeDeclaration[1];
            PreorderWalker walker = new PreorderWalker((Object)nsItem, (Navigator)navigator);
            try {
                WalkerUtil.walk((Walker)walker, (Processor)new Processor(){
                    int i = 0;

                    public boolean preProcess(Object elem, Path path) {
                        if (path.getParentPath() != null) {
                            QName qname = XSUtil.getQName((XSObject)(elem instanceof XSAttributeUse ? ((XSAttributeUse)elem).getAttrDeclaration() : (XSObject)elem));
                            if (qname.equals(xpath.get(this.i)) && (this.i != xpath.size() - 1 || elem instanceof XSAttributeUse)) {
                                ++this.i;
                                if (this.i == xpath.size()) {
                                    declaration[0] = ((XSAttributeUse)elem).getAttrDeclaration();
                                    throw STOP_SEARCHING;
                                }
                                return true;
                            }
                            return false;
                        }
                        return true;
                    }

                    public void postProcess(Object elem, Path path) {
                    }
                });
            }
            catch (RuntimeException ex) {
                if (ex == STOP_SEARCHING) break block3;
                throw ex;
            }
        }
        return declaration[0];
    }

    public static void getNamespacePrefixes(final URL xsdURL, final Set<URL> crawled, final Properties prefixes) throws ParserConfigurationException, SAXException, IOException {
        crawled.add(xsdURL);
        SAXParser saxParser = SAXUtil.newSAXParser((boolean)true, (boolean)false, (boolean)false);
        saxParser.parse(xsdURL.toString(), new DefaultHandler(){

            @Override
            public void startPrefixMapping(String prefix, String uri) throws SAXException {
                if (Namespaces.suggestPrefix((String)uri) == null && !prefixes.containsKey(uri)) {
                    prefixes.put(uri, prefix);
                }
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                try {
                    URL url;
                    String location;
                    if ("http://www.w3.org/2001/XMLSchema".equals(uri) && ("import".equals(localName) || "include".equals(localName)) && (location = attributes.getValue("location")) != null && !crawled.contains(url = URLUtil.toURI((URL)xsdURL).resolve(location).toURL())) {
                        XSUtil.getNamespacePrefixes(url, crawled, prefixes);
                    }
                }
                catch (Exception ex) {
                    if (ex instanceof SAXException) {
                        throw (SAXException)ex;
                    }
                    throw new SAXException(ex);
                }
            }
        });
    }

    public static void suggestNamespacePrefixes(URL xsdURL, XMLDocument xml) throws IOException, SAXException, ParserConfigurationException {
        Properties prefixes = new Properties();
        XSUtil.getNamespacePrefixes(xsdURL, new HashSet<URL>(), prefixes);
        for (Map.Entry<Object, Object> entry : prefixes.entrySet()) {
            String uri = (String)entry.getKey();
            String prefix = (String)entry.getValue();
            xml.suggestPrefix(prefix, uri);
        }
    }
}

