/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Catalog;
import io.aeron.archive.client.RecordingDescriptorConsumer;
import io.aeron.archive.codecs.RecordingDescriptorDecoder;
import io.aeron.archive.codecs.RecordingDescriptorEncoder;
import io.aeron.archive.codecs.RecordingDescriptorHeaderDecoder;
import io.aeron.archive.codecs.RecordingDescriptorHeaderEncoder;
import java.io.File;

public class CatalogView {
    public static int listRecordings(File archiveDir, RecordingDescriptorConsumer consumer) {
        try (Catalog catalog = new Catalog(archiveDir, System::currentTimeMillis);){
            int n = catalog.forEach(new RecordingDescriptorConsumerAdapter(consumer));
            return n;
        }
    }

    public static boolean listRecording(File archiveDir, long recordingId, RecordingDescriptorConsumer consumer) {
        try (Catalog catalog = new Catalog(archiveDir, System::currentTimeMillis);){
            boolean bl = catalog.forEntry(recordingId, new RecordingDescriptorConsumerAdapter(consumer));
            return bl;
        }
    }

    static class RecordingDescriptorConsumerAdapter
    implements Catalog.CatalogEntryProcessor {
        private final RecordingDescriptorConsumer consumer;

        RecordingDescriptorConsumerAdapter(RecordingDescriptorConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public void accept(int recordingDescriptorOffset, RecordingDescriptorHeaderEncoder headerEncoder, RecordingDescriptorHeaderDecoder headerDecoder, RecordingDescriptorEncoder descriptorEncoder, RecordingDescriptorDecoder descriptorDecoder) {
            this.consumer.onRecordingDescriptor(-1L, -1L, descriptorDecoder.recordingId(), descriptorDecoder.startTimestamp(), descriptorDecoder.stopTimestamp(), descriptorDecoder.startPosition(), descriptorDecoder.stopPosition(), descriptorDecoder.initialTermId(), descriptorDecoder.segmentFileLength(), descriptorDecoder.termBufferLength(), descriptorDecoder.mtuLength(), descriptorDecoder.sessionId(), descriptorDecoder.streamId(), descriptorDecoder.strippedChannel(), descriptorDecoder.originalChannel(), descriptorDecoder.sourceIdentity());
        }
    }
}

