/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.ControlResponseProxy;
import io.aeron.archive.ControlSession;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.security.SessionProxy;

class ControlSessionProxy
implements SessionProxy {
    private final ControlResponseProxy controlResponseProxy;
    private ControlSession controlSession;

    ControlSessionProxy(ControlResponseProxy controlResponseProxy) {
        this.controlResponseProxy = controlResponseProxy;
    }

    ControlSessionProxy controlSession(ControlSession controlSession) {
        this.controlSession = controlSession;
        return this;
    }

    @Override
    public long sessionId() {
        return this.controlSession.sessionId();
    }

    @Override
    public boolean challenge(byte[] encodedChallenge) {
        if (this.controlResponseProxy.sendChallenge(this.controlSession.sessionId(), this.controlSession.correlationId(), encodedChallenge, this.controlSession)) {
            this.controlSession.challenged();
            return true;
        }
        return false;
    }

    @Override
    public boolean authenticate(byte[] encodedPrincipal) {
        if (this.controlResponseProxy.sendResponse(this.controlSession.sessionId(), this.controlSession.correlationId(), this.controlSession.sessionId(), ControlResponseCode.OK, null, this.controlSession)) {
            this.controlSession.authenticate(encodedPrincipal);
            return true;
        }
        return false;
    }

    @Override
    public void reject() {
        this.controlSession.reject();
    }
}

