/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.security.NullCredentialsSupplier;
import java.util.Objects;

public class ReplicationParams {
    private long stopPosition;
    private long dstRecordingId;
    private String liveDestination;
    private String replicationChannel;
    private long channelTagId;
    private long subscriptionTagId;
    private int fileIoMaxLength;
    private int replicationSessionId;
    private byte[] encodedCredentials;

    public ReplicationParams() {
        this.reset();
    }

    public ReplicationParams reset() {
        this.stopPosition = -1L;
        this.dstRecordingId = -1L;
        this.liveDestination = null;
        this.replicationChannel = null;
        this.channelTagId = -1L;
        this.subscriptionTagId = -1L;
        this.fileIoMaxLength = -1;
        this.replicationSessionId = -1;
        this.encodedCredentials = NullCredentialsSupplier.NULL_CREDENTIAL;
        return this;
    }

    public ReplicationParams stopPosition(long stopPosition) {
        this.stopPosition = stopPosition;
        return this;
    }

    public long stopPosition() {
        return this.stopPosition;
    }

    public ReplicationParams dstRecordingId(long dstRecordingId) {
        this.dstRecordingId = dstRecordingId;
        return this;
    }

    public long dstRecordingId() {
        return this.dstRecordingId;
    }

    public ReplicationParams liveDestination(String liveChannel) {
        this.liveDestination = liveChannel;
        return this;
    }

    public String liveDestination() {
        return this.liveDestination;
    }

    public String replicationChannel() {
        return this.replicationChannel;
    }

    public ReplicationParams replicationChannel(String replicationChannel) {
        this.replicationChannel = replicationChannel;
        return this;
    }

    public ReplicationParams channelTagId(long channelTagId) {
        this.channelTagId = channelTagId;
        return this;
    }

    public long channelTagId() {
        return this.channelTagId;
    }

    public ReplicationParams subscriptionTagId(long subscriptionTagId) {
        this.subscriptionTagId = subscriptionTagId;
        return this;
    }

    public long subscriptionTagId() {
        return this.subscriptionTagId;
    }

    public ReplicationParams fileIoMaxLength(int fileIoMaxLength) {
        this.fileIoMaxLength = fileIoMaxLength;
        return this;
    }

    public int fileIoMaxLength() {
        return this.fileIoMaxLength;
    }

    public ReplicationParams replicationSessionId(int replicationSessionId) {
        this.replicationSessionId = replicationSessionId;
        return this;
    }

    public int replicationSessionId() {
        return this.replicationSessionId;
    }

    public ReplicationParams encodedCredentials(byte[] encodedCredentials) {
        this.encodedCredentials = encodedCredentials;
        return this;
    }

    public byte[] encodedCredentials() {
        return this.encodedCredentials;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationParams that = (ReplicationParams)o;
        return this.stopPosition == that.stopPosition && this.dstRecordingId == that.dstRecordingId && this.channelTagId == that.channelTagId && this.subscriptionTagId == that.subscriptionTagId && this.fileIoMaxLength == that.fileIoMaxLength && this.replicationSessionId == that.replicationSessionId && Objects.equals(this.liveDestination, that.liveDestination) && Objects.equals(this.replicationChannel, that.replicationChannel);
    }

    public int hashCode() {
        return Objects.hash(this.stopPosition, this.dstRecordingId, this.liveDestination, this.replicationChannel, this.channelTagId, this.subscriptionTagId, this.fileIoMaxLength, this.replicationSessionId);
    }

    public String toString() {
        return "ReplicationParams{stopPosition=" + this.stopPosition + ", dstRecordingId=" + this.dstRecordingId + ", liveDestination='" + this.liveDestination + '\'' + ", replicationChannel='" + this.replicationChannel + '\'' + ", channelTagId=" + this.channelTagId + ", subscriptionTagId=" + this.subscriptionTagId + ", fileIoMaxLength=" + this.fileIoMaxLength + ", replicationSessionId=" + this.replicationSessionId + '}';
    }
}

