/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.Publication;
import io.aeron.cluster.client.ClusterEvent;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.CloseReason;
import io.aeron.cluster.codecs.EventCode;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.RegistrationException;
import io.aeron.logbuffer.BufferClaim;
import java.util.Arrays;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.errors.DistinctErrorLog;

final class ClusterSession {
    static final byte[] NULL_PRINCIPAL = ArrayUtil.EMPTY_BYTE_ARRAY;
    static final int MAX_ENCODED_PRINCIPAL_LENGTH = 4096;
    static final int MAX_ENCODED_MEMBERSHIP_QUERY_LENGTH = 4096;
    private boolean hasNewLeaderEventPending = false;
    private boolean hasOpenEventPending = true;
    private final long id;
    private long correlationId;
    private long openedLogPosition = -1L;
    private long closedLogPosition = -1L;
    private transient long timeOfLastActivityNs;
    private long responsePublicationId = -1L;
    private final int responseStreamId;
    private final String responseChannel;
    private Publication responsePublication;
    private State state;
    private String responseDetail = null;
    private EventCode eventCode = null;
    private CloseReason closeReason = CloseReason.NULL_VAL;
    private byte[] encodedPrincipal = NULL_PRINCIPAL;
    private Action action = Action.CLIENT;
    private Object requestInput = null;

    ClusterSession(long sessionId, int responseStreamId, String responseChannel) {
        this.id = sessionId;
        this.responseStreamId = responseStreamId;
        this.responseChannel = responseChannel;
        this.state(State.INIT);
    }

    ClusterSession(long id, long correlationId, long openedLogPosition, long timeOfLastActivityNs, int responseStreamId, String responseChannel, CloseReason closeReason) {
        this.id = id;
        this.responseStreamId = responseStreamId;
        this.responseChannel = responseChannel;
        this.openedLogPosition = openedLogPosition;
        this.timeOfLastActivityNs = timeOfLastActivityNs;
        this.correlationId = correlationId;
        this.closeReason = closeReason;
        if (CloseReason.NULL_VAL != closeReason) {
            this.state(State.CLOSING);
        } else {
            this.state(State.OPEN);
        }
    }

    public void close(Aeron aeron, ErrorHandler errorHandler) {
        if (null == this.responsePublication) {
            aeron.asyncRemovePublication(this.responsePublicationId);
        } else {
            CloseHelper.close(errorHandler, this.responsePublication);
            this.responsePublication = null;
        }
        this.state(State.CLOSED);
    }

    long id() {
        return this.id;
    }

    int responseStreamId() {
        return this.responseStreamId;
    }

    String responseChannel() {
        return this.responseChannel;
    }

    void closing(CloseReason closeReason) {
        this.closeReason = closeReason;
        this.hasOpenEventPending = false;
        this.hasNewLeaderEventPending = false;
        this.timeOfLastActivityNs = 0L;
        this.state(State.CLOSING);
    }

    CloseReason closeReason() {
        return this.closeReason;
    }

    void resetCloseReason() {
        this.closedLogPosition = -1L;
        this.closeReason = CloseReason.NULL_VAL;
    }

    void asyncConnect(Aeron aeron) {
        this.responsePublicationId = aeron.asyncAddPublication(this.responseChannel, this.responseStreamId);
    }

    void connect(ErrorHandler errorHandler, Aeron aeron) {
        if (null != this.responsePublication) {
            throw new ClusterException("response publication already added");
        }
        try {
            this.responsePublication = aeron.addPublication(this.responseChannel, this.responseStreamId);
        }
        catch (RegistrationException ex) {
            errorHandler.onError(new ClusterException("failed to connect session response publication: " + ex.getMessage(), AeronException.Category.WARN));
        }
    }

    void disconnect(Aeron aeron, ErrorHandler errorHandler) {
        if (null == this.responsePublication) {
            aeron.asyncRemovePublication(this.responsePublicationId);
        } else {
            CloseHelper.close(errorHandler, this.responsePublication);
            this.responsePublication = null;
        }
    }

    boolean isResponsePublicationConnected(Aeron aeron, long nowNs) {
        if (null == this.responsePublication && !aeron.isCommandActive(this.responsePublicationId)) {
            this.responsePublication = aeron.getPublication(this.responsePublicationId);
            if (null != this.responsePublication) {
                this.responsePublicationId = -1L;
                this.timeOfLastActivityNs = nowNs;
                this.state(State.CONNECTING);
            } else {
                this.responsePublicationId = -1L;
                this.state(State.INVALID);
            }
        }
        return null != this.responsePublication && this.responsePublication.isConnected();
    }

    public long tryClaim(int length, BufferClaim bufferClaim) {
        if (null == this.responsePublication) {
            return -1L;
        }
        return this.responsePublication.tryClaim(length, bufferClaim);
    }

    public long offer(DirectBuffer buffer, int offset, int length) {
        if (null == this.responsePublication) {
            return -1L;
        }
        return this.responsePublication.offer(buffer, offset, length);
    }

    State state() {
        return this.state;
    }

    void state(State newState) {
        this.state = newState;
    }

    void authenticate(byte[] encodedPrincipal) {
        if (encodedPrincipal != null) {
            this.encodedPrincipal = encodedPrincipal;
        }
        this.state(State.AUTHENTICATED);
    }

    void open(long openedLogPosition) {
        this.openedLogPosition = openedLogPosition;
        this.encodedPrincipal = null;
        this.state(State.OPEN);
    }

    byte[] encodedPrincipal() {
        return this.encodedPrincipal;
    }

    void lastActivityNs(long timeNs, long correlationId) {
        this.timeOfLastActivityNs = timeNs;
        this.correlationId = correlationId;
    }

    void reject(EventCode code, String responseDetail, DistinctErrorLog errorLog, int clusterMemberId) {
        this.eventCode = code;
        this.responseDetail = responseDetail;
        this.state(State.REJECTED);
        if (null != errorLog) {
            errorLog.record(new ClusterEvent((Object)((Object)code) + " " + responseDetail + ", clusterMemberId=" + clusterMemberId + ", id=" + this.id));
        }
    }

    void reject(EventCode code, String responseDetail) {
        this.reject(code, responseDetail, null, -1);
    }

    EventCode eventCode() {
        return this.eventCode;
    }

    String responseDetail() {
        return this.responseDetail;
    }

    long timeOfLastActivityNs() {
        return this.timeOfLastActivityNs;
    }

    void timeOfLastActivityNs(long timeNs) {
        this.timeOfLastActivityNs = timeNs;
    }

    long correlationId() {
        return this.correlationId;
    }

    long openedLogPosition() {
        return this.openedLogPosition;
    }

    void closedLogPosition(long closedLogPosition) {
        this.closedLogPosition = closedLogPosition;
    }

    long closedLogPosition() {
        return this.closedLogPosition;
    }

    void hasNewLeaderEventPending(boolean flag) {
        this.hasNewLeaderEventPending = flag;
    }

    boolean hasNewLeaderEventPending() {
        return this.hasNewLeaderEventPending;
    }

    boolean hasOpenEventPending() {
        return this.hasOpenEventPending;
    }

    void clearOpenEventPending() {
        this.hasOpenEventPending = false;
    }

    Action action() {
        return this.action;
    }

    void action(Action action) {
        this.action = action;
    }

    Publication responsePublication() {
        return this.responsePublication;
    }

    void requestInput(Object requestInput) {
        this.requestInput = requestInput;
    }

    Object requestInput() {
        return this.requestInput;
    }

    static void checkEncodedPrincipalLength(byte[] encodedPrincipal) {
        if (null != encodedPrincipal && encodedPrincipal.length > 4096) {
            throw new ClusterException("encoded principal max length 4096 exceeded: length=" + encodedPrincipal.length);
        }
    }

    public String toString() {
        return "ClusterSession{id=" + this.id + ", correlationId=" + this.correlationId + ", openedLogPosition=" + this.openedLogPosition + ", closedLogPosition=" + this.closedLogPosition + ", timeOfLastActivityNs=" + this.timeOfLastActivityNs + ", responseStreamId=" + this.responseStreamId + ", responseChannel='" + this.responseChannel + '\'' + ", responsePublicationId=" + this.responsePublicationId + ", closeReason=" + (Object)((Object)this.closeReason) + ", state=" + (Object)((Object)this.state) + ", hasNewLeaderEventPending=" + this.hasNewLeaderEventPending + ", hasOpenEventPending=" + this.hasOpenEventPending + ", encodedPrincipal=" + Arrays.toString(this.encodedPrincipal) + '}';
    }

    static enum Action {
        CLIENT,
        BACKUP,
        HEARTBEAT,
        STANDBY_SNAPSHOT;

    }

    static enum State {
        INIT,
        CONNECTING,
        CONNECTED,
        CHALLENGED,
        AUTHENTICATED,
        REJECTED,
        OPEN,
        CLOSING,
        INVALID,
        CLOSED;

    }
}

