/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class JoinLogDecoder {
    public static final int BLOCK_LENGTH = 36;
    public static final int TEMPLATE_ID = 40;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final JoinLogDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 36;
    }

    public int sbeTemplateId() {
        return 40;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 12;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public JoinLogDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public JoinLogDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (40 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public JoinLogDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int logPositionId() {
        return 1;
    }

    public static int logPositionSinceVersion() {
        return 0;
    }

    public static int logPositionEncodingOffset() {
        return 0;
    }

    public static int logPositionEncodingLength() {
        return 8;
    }

    public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long logPosition() {
        return this.buffer.getLong(this.offset + 0, BYTE_ORDER);
    }

    public static int maxLogPositionId() {
        return 2;
    }

    public static int maxLogPositionSinceVersion() {
        return 0;
    }

    public static int maxLogPositionEncodingOffset() {
        return 8;
    }

    public static int maxLogPositionEncodingLength() {
        return 8;
    }

    public static String maxLogPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long maxLogPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long maxLogPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long maxLogPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long maxLogPosition() {
        return this.buffer.getLong(this.offset + 8, BYTE_ORDER);
    }

    public static int memberIdId() {
        return 3;
    }

    public static int memberIdSinceVersion() {
        return 0;
    }

    public static int memberIdEncodingOffset() {
        return 16;
    }

    public static int memberIdEncodingLength() {
        return 4;
    }

    public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int memberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int memberIdMinValue() {
        return -2147483647;
    }

    public static int memberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int memberId() {
        return this.buffer.getInt(this.offset + 16, BYTE_ORDER);
    }

    public static int logSessionIdId() {
        return 4;
    }

    public static int logSessionIdSinceVersion() {
        return 0;
    }

    public static int logSessionIdEncodingOffset() {
        return 20;
    }

    public static int logSessionIdEncodingLength() {
        return 4;
    }

    public static String logSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int logSessionIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int logSessionIdMinValue() {
        return -2147483647;
    }

    public static int logSessionIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int logSessionId() {
        return this.buffer.getInt(this.offset + 20, BYTE_ORDER);
    }

    public static int logStreamIdId() {
        return 5;
    }

    public static int logStreamIdSinceVersion() {
        return 0;
    }

    public static int logStreamIdEncodingOffset() {
        return 24;
    }

    public static int logStreamIdEncodingLength() {
        return 4;
    }

    public static String logStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int logStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int logStreamIdMinValue() {
        return -2147483647;
    }

    public static int logStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int logStreamId() {
        return this.buffer.getInt(this.offset + 24, BYTE_ORDER);
    }

    public static int isStartupId() {
        return 6;
    }

    public static int isStartupSinceVersion() {
        return 0;
    }

    public static int isStartupEncodingOffset() {
        return 28;
    }

    public static int isStartupEncodingLength() {
        return 4;
    }

    public static String isStartupMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public int isStartupRaw() {
        return this.buffer.getInt(this.offset + 28, BYTE_ORDER);
    }

    public BooleanType isStartup() {
        return BooleanType.get(this.buffer.getInt(this.offset + 28, BYTE_ORDER));
    }

    public static int roleId() {
        return 7;
    }

    public static int roleSinceVersion() {
        return 0;
    }

    public static int roleEncodingOffset() {
        return 32;
    }

    public static int roleEncodingLength() {
        return 4;
    }

    public static String roleMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int roleNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int roleMinValue() {
        return -2147483647;
    }

    public static int roleMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int role() {
        return this.buffer.getInt(this.offset + 32, BYTE_ORDER);
    }

    public static int logChannelId() {
        return 8;
    }

    public static int logChannelSinceVersion() {
        return 0;
    }

    public static String logChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String logChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int logChannelHeaderLength() {
        return 4;
    }

    public int logChannelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
    }

    public int skipLogChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getLogChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getLogChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapLogChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String logChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getLogChannel(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        JoinLogDecoder decoder = new JoinLogDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[JoinLog](sbeTemplateId=");
        builder.append(40);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 12) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(12);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 36) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(36);
        builder.append("):");
        builder.append("logPosition=");
        builder.append(this.logPosition());
        builder.append('|');
        builder.append("maxLogPosition=");
        builder.append(this.maxLogPosition());
        builder.append('|');
        builder.append("memberId=");
        builder.append(this.memberId());
        builder.append('|');
        builder.append("logSessionId=");
        builder.append(this.logSessionId());
        builder.append('|');
        builder.append("logStreamId=");
        builder.append(this.logStreamId());
        builder.append('|');
        builder.append("isStartup=");
        builder.append((Object)this.isStartup());
        builder.append('|');
        builder.append("role=");
        builder.append(this.role());
        builder.append('|');
        builder.append("logChannel=");
        builder.append('\'');
        this.getLogChannel(builder);
        builder.append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public JoinLogDecoder sbeSkip() {
        this.sbeRewind();
        this.skipLogChannel();
        return this;
    }
}

