/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class StandbySnapshotDecoder {
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 81;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final StandbySnapshotDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final SnapshotsDecoder snapshots = new SnapshotsDecoder(this);

    public int sbeBlockLength() {
        return 16;
    }

    public int sbeTemplateId() {
        return 81;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 12;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public StandbySnapshotDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public StandbySnapshotDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (81 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public StandbySnapshotDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int correlationIdId() {
        return 1;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 0;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 0, BYTE_ORDER);
    }

    public static int versionId() {
        return 2;
    }

    public static int versionSinceVersion() {
        return 0;
    }

    public static int versionEncodingOffset() {
        return 8;
    }

    public static int versionEncodingLength() {
        return 4;
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int versionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int versionMinValue() {
        return -2147483647;
    }

    public static int versionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int version() {
        return this.buffer.getInt(this.offset + 8, BYTE_ORDER);
    }

    public static int responseStreamIdId() {
        return 3;
    }

    public static int responseStreamIdSinceVersion() {
        return 0;
    }

    public static int responseStreamIdEncodingOffset() {
        return 12;
    }

    public static int responseStreamIdEncodingLength() {
        return 4;
    }

    public static String responseStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int responseStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int responseStreamIdMinValue() {
        return -2147483647;
    }

    public static int responseStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int responseStreamId() {
        return this.buffer.getInt(this.offset + 12, BYTE_ORDER);
    }

    public static long snapshotsDecoderId() {
        return 4L;
    }

    public static int snapshotsDecoderSinceVersion() {
        return 0;
    }

    public SnapshotsDecoder snapshots() {
        this.snapshots.wrap(this.buffer);
        return this.snapshots;
    }

    public static int responseChannelId() {
        return 12;
    }

    public static int responseChannelSinceVersion() {
        return 0;
    }

    public static String responseChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String responseChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int responseChannelHeaderLength() {
        return 4;
    }

    public int responseChannelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
    }

    public int skipResponseChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getResponseChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getResponseChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapResponseChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String responseChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getResponseChannel(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public static int encodedCredentialsId() {
        return 13;
    }

    public static int encodedCredentialsSinceVersion() {
        return 0;
    }

    public static String encodedCredentialsMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int encodedCredentialsHeaderLength() {
        return 4;
    }

    public int encodedCredentialsLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
    }

    public int skipEncodedCredentials() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getEncodedCredentials(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getEncodedCredentials(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapEncodedCredentials(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        StandbySnapshotDecoder decoder = new StandbySnapshotDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[StandbySnapshot](sbeTemplateId=");
        builder.append(81);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 12) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(12);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 16) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(16);
        builder.append("):");
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("version=");
        builder.append(this.version());
        builder.append('|');
        builder.append("responseStreamId=");
        builder.append(this.responseStreamId());
        builder.append('|');
        builder.append("snapshots=[");
        int snapshotsOriginalOffset = this.snapshots.offset;
        int snapshotsOriginalIndex = this.snapshots.index;
        SnapshotsDecoder snapshots = this.snapshots();
        if (snapshots.count() > 0) {
            while (snapshots.hasNext()) {
                snapshots.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        snapshots.offset = snapshotsOriginalOffset;
        snapshots.index = snapshotsOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("responseChannel=");
        builder.append('\'');
        this.getResponseChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("encodedCredentials=");
        builder.append(this.skipEncodedCredentials()).append(" bytes of raw data");
        this.limit(originalLimit);
        return builder;
    }

    public StandbySnapshotDecoder sbeSkip() {
        this.sbeRewind();
        SnapshotsDecoder snapshots = this.snapshots();
        if (snapshots.count() > 0) {
            while (snapshots.hasNext()) {
                snapshots.next();
                snapshots.sbeSkip();
            }
        }
        this.skipResponseChannel();
        this.skipEncodedCredentials();
        return this;
    }

    public static final class SnapshotsDecoder
    implements Iterable<SnapshotsDecoder>,
    Iterator<SnapshotsDecoder> {
        public static final int HEADER_SIZE = 4;
        private final StandbySnapshotDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        SnapshotsDecoder(StandbySnapshotDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4);
            this.blockLength = buffer.getShort(limit + 0, BYTE_ORDER) & 0xFFFF;
            this.count = buffer.getShort(limit + 2, BYTE_ORDER) & 0xFFFF;
        }

        @Override
        public SnapshotsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int countMinValue() {
            return 0;
        }

        public static int countMaxValue() {
            return 65534;
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 44;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<SnapshotsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int recordingIdId() {
            return 5;
        }

        public static int recordingIdSinceVersion() {
            return 0;
        }

        public static int recordingIdEncodingOffset() {
            return 0;
        }

        public static int recordingIdEncodingLength() {
            return 8;
        }

        public static String recordingIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long recordingIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long recordingIdMinValue() {
            return -9223372036854775807L;
        }

        public static long recordingIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public long recordingId() {
            return this.buffer.getLong(this.offset + 0, BYTE_ORDER);
        }

        public static int leadershipTermIdId() {
            return 6;
        }

        public static int leadershipTermIdSinceVersion() {
            return 0;
        }

        public static int leadershipTermIdEncodingOffset() {
            return 8;
        }

        public static int leadershipTermIdEncodingLength() {
            return 8;
        }

        public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long leadershipTermIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long leadershipTermIdMinValue() {
            return -9223372036854775807L;
        }

        public static long leadershipTermIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public long leadershipTermId() {
            return this.buffer.getLong(this.offset + 8, BYTE_ORDER);
        }

        public static int termBaseLogPositionId() {
            return 7;
        }

        public static int termBaseLogPositionSinceVersion() {
            return 0;
        }

        public static int termBaseLogPositionEncodingOffset() {
            return 16;
        }

        public static int termBaseLogPositionEncodingLength() {
            return 8;
        }

        public static String termBaseLogPositionMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long termBaseLogPositionNullValue() {
            return Long.MIN_VALUE;
        }

        public static long termBaseLogPositionMinValue() {
            return -9223372036854775807L;
        }

        public static long termBaseLogPositionMaxValue() {
            return Long.MAX_VALUE;
        }

        public long termBaseLogPosition() {
            return this.buffer.getLong(this.offset + 16, BYTE_ORDER);
        }

        public static int logPositionId() {
            return 8;
        }

        public static int logPositionSinceVersion() {
            return 0;
        }

        public static int logPositionEncodingOffset() {
            return 24;
        }

        public static int logPositionEncodingLength() {
            return 8;
        }

        public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long logPositionNullValue() {
            return Long.MIN_VALUE;
        }

        public static long logPositionMinValue() {
            return -9223372036854775807L;
        }

        public static long logPositionMaxValue() {
            return Long.MAX_VALUE;
        }

        public long logPosition() {
            return this.buffer.getLong(this.offset + 24, BYTE_ORDER);
        }

        public static int timestampId() {
            return 9;
        }

        public static int timestampSinceVersion() {
            return 0;
        }

        public static int timestampEncodingOffset() {
            return 32;
        }

        public static int timestampEncodingLength() {
            return 8;
        }

        public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long timestampNullValue() {
            return Long.MIN_VALUE;
        }

        public static long timestampMinValue() {
            return -9223372036854775807L;
        }

        public static long timestampMaxValue() {
            return Long.MAX_VALUE;
        }

        public long timestamp() {
            return this.buffer.getLong(this.offset + 32, BYTE_ORDER);
        }

        public static int serviceIdId() {
            return 10;
        }

        public static int serviceIdSinceVersion() {
            return 0;
        }

        public static int serviceIdEncodingOffset() {
            return 40;
        }

        public static int serviceIdEncodingLength() {
            return 4;
        }

        public static String serviceIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int serviceIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int serviceIdMinValue() {
            return -2147483647;
        }

        public static int serviceIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public int serviceId() {
            return this.buffer.getInt(this.offset + 40, BYTE_ORDER);
        }

        public static int archiveEndpointId() {
            return 11;
        }

        public static int archiveEndpointSinceVersion() {
            return 0;
        }

        public static String archiveEndpointCharacterEncoding() {
            return StandardCharsets.US_ASCII.name();
        }

        public static String archiveEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int archiveEndpointHeaderLength() {
            return 4;
        }

        public int archiveEndpointLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        }

        public int skipArchiveEndpoint() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getArchiveEndpoint(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getArchiveEndpoint(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapArchiveEndpoint(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String archiveEndpoint() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            return new String(tmp, StandardCharsets.US_ASCII);
        }

        public int getArchiveEndpoint(Appendable appendable) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
            return dataLength;
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("recordingId=");
            builder.append(this.recordingId());
            builder.append('|');
            builder.append("leadershipTermId=");
            builder.append(this.leadershipTermId());
            builder.append('|');
            builder.append("termBaseLogPosition=");
            builder.append(this.termBaseLogPosition());
            builder.append('|');
            builder.append("logPosition=");
            builder.append(this.logPosition());
            builder.append('|');
            builder.append("timestamp=");
            builder.append(this.timestamp());
            builder.append('|');
            builder.append("serviceId=");
            builder.append(this.serviceId());
            builder.append('|');
            builder.append("archiveEndpoint=");
            builder.append('\'');
            this.getArchiveEndpoint(builder);
            builder.append('\'');
            builder.append(')');
            return builder;
        }

        public SnapshotsDecoder sbeSkip() {
            this.skipArchiveEndpoint();
            return this;
        }
    }
}

