/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs.node;

import io.aeron.cluster.codecs.node.MessageHeaderEncoder;
import io.aeron.cluster.codecs.node.NodeStateFooterDecoder;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;

public final class NodeStateFooterEncoder {
    public static final int BLOCK_LENGTH = 0;
    public static final int TEMPLATE_ID = 304;
    public static final int SCHEMA_ID = 112;
    public static final int SCHEMA_VERSION = 10;
    public static final String SEMANTIC_VERSION = "5.3";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final NodeStateFooterEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 0;
    }

    public int sbeTemplateId() {
        return 304;
    }

    public int sbeSchemaId() {
        return 112;
    }

    public int sbeSchemaVersion() {
        return 10;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public NodeStateFooterEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 0);
        return this;
    }

    public NodeStateFooterEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(0).templateId(304).schemaId(112).version(10);
        return this.wrap(buffer, offset + 16);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        NodeStateFooterDecoder decoder = new NodeStateFooterDecoder();
        decoder.wrap(this.buffer, this.offset, 0, 10);
        return decoder.appendTo(builder);
    }
}

