/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.FlowControl;
import io.aeron.driver.FlowControlSupplier;
import io.aeron.driver.UnicastFlowControl;
import io.aeron.driver.media.UdpChannel;
import org.agrona.LangUtil;

public class DefaultUnicastFlowControlSupplier
implements FlowControlSupplier {
    @Override
    public FlowControl newInstance(UdpChannel udpChannel, int streamId, long registrationId) {
        String fcStr = udpChannel.channelUri().get("fc");
        FlowControl flowControl = null;
        if (null != fcStr) {
            throw new IllegalArgumentException("unsupported unicast flow control strategy: fc=" + fcStr);
        }
        if (UnicastFlowControl.class.getName().equals(Configuration.UNICAST_FLOW_CONTROL_STRATEGY)) {
            return UnicastFlowControl.INSTANCE;
        }
        try {
            flowControl = (FlowControl)Class.forName(Configuration.UNICAST_FLOW_CONTROL_STRATEGY).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return flowControl;
    }

    public String toString() {
        return "DefaultUnicastFlowControlSupplier{flowControlClass=" + Configuration.UNICAST_FLOW_CONTROL_STRATEGY + "}";
    }
}

