/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.AeronClient;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.IpcPublication;
import io.aeron.driver.NetworkPublication;

final class PublicationLink
implements DriverManagedResource {
    private final long registrationId;
    private final Object publication;
    private final AeronClient client;
    private boolean reachedEndOfLife = false;

    PublicationLink(long registrationId, AeronClient client, NetworkPublication publication) {
        this.registrationId = registrationId;
        this.client = client;
        this.publication = publication;
        publication.incRef();
    }

    PublicationLink(long registrationId, AeronClient client, IpcPublication publication) {
        this.registrationId = registrationId;
        this.client = client;
        this.publication = publication;
        publication.incRef();
    }

    @Override
    public void close() {
        if (this.publication instanceof NetworkPublication) {
            ((NetworkPublication)this.publication).decRef();
        } else {
            ((IpcPublication)this.publication).decRef();
        }
    }

    @Override
    public void onTimeEvent(long timeNs, long timeMs, DriverConductor conductor) {
        if (this.client.hasTimedOut()) {
            this.reachedEndOfLife = true;
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    long registrationId() {
        return this.registrationId;
    }
}

