/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.protocol;

import io.aeron.exceptions.AeronException;
import io.aeron.protocol.HeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;

public class StatusMessageFlyweight
extends HeaderFlyweight {
    public static final int HEADER_LENGTH = 36;
    public static final short SEND_SETUP_FLAG = 128;
    public static final short END_OF_STREAM_FLAG = 64;
    private static final int SESSION_ID_FIELD_OFFSET = 8;
    private static final int STREAM_ID_FIELD_OFFSET = 12;
    private static final int CONSUMPTION_TERM_ID_FIELD_OFFSET = 16;
    private static final int CONSUMPTION_TERM_OFFSET_FIELD_OFFSET = 20;
    private static final int RECEIVER_WINDOW_FIELD_OFFSET = 24;
    private static final int RECEIVER_ID_FIELD_OFFSET = 28;
    private static final int APP_SPECIFIC_FEEDBACK_FIELD_OFFSET = 36;
    private static final int GROUP_TAG_FIELD_OFFSET = 36;

    public StatusMessageFlyweight() {
    }

    public StatusMessageFlyweight(ByteBuffer buffer) {
        super(buffer);
    }

    public StatusMessageFlyweight(UnsafeBuffer buffer) {
        super(buffer);
    }

    public int sessionId() {
        return this.getInt(8, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight sessionId(int sessionId) {
        this.putInt(8, sessionId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int streamId() {
        return this.getInt(12, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight streamId(int streamId) {
        this.putInt(12, streamId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int consumptionTermOffset() {
        return this.getInt(20, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight consumptionTermOffset(int termOffset) {
        this.putInt(20, termOffset, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int consumptionTermId() {
        return this.getInt(16, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight consumptionTermId(int termId) {
        this.putInt(16, termId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int receiverWindowLength() {
        return this.getInt(24, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight receiverWindowLength(int receiverWindowLength) {
        this.putInt(24, receiverWindowLength, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public long receiverId() {
        return this.getLongUnaligned(28);
    }

    public StatusMessageFlyweight receiverId(long id) {
        return this.putLongUnaligned(28, id);
    }

    public int asfLength() {
        return this.frameLength() - 36;
    }

    public long groupTag() {
        int frameLength = this.frameLength();
        if (frameLength > 36) {
            if (frameLength > 44) {
                throw new AeronException("SM has longer application specific feedback (" + (frameLength - 36) + ") than gtag");
            }
            return this.getLongUnaligned(36);
        }
        return 0L;
    }

    public StatusMessageFlyweight groupTag(Long groupTag) {
        if (null != groupTag) {
            this.frameLength(44);
            this.putLongUnaligned(36, groupTag);
        } else {
            this.frameLength(36);
        }
        return this;
    }

    public static int groupTagFieldOffset() {
        return 36;
    }

    public long getLongUnaligned(int offset) {
        long value = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? (long)this.getByte(offset + 7) << 56 | ((long)this.getByte(offset + 6) & 0xFFL) << 48 | ((long)this.getByte(offset + 5) & 0xFFL) << 40 | ((long)this.getByte(offset + 4) & 0xFFL) << 32 | ((long)this.getByte(offset + 3) & 0xFFL) << 24 | ((long)this.getByte(offset + 2) & 0xFFL) << 16 | ((long)this.getByte(offset + 1) & 0xFFL) << 8 | (long)this.getByte(offset) & 0xFFL : (long)this.getByte(offset) << 56 | ((long)this.getByte(offset + 1) & 0xFFL) << 48 | ((long)this.getByte(offset + 2) & 0xFFL) << 40 | ((long)this.getByte(offset + 3) & 0xFFL) << 32 | ((long)this.getByte(offset + 4) & 0xFFL) << 24 | ((long)this.getByte(offset + 5) & 0xFFL) << 16 | ((long)this.getByte(offset + 6) & 0xFFL) << 8 | (long)this.getByte(offset + 7) & 0xFFL;
        return value;
    }

    public StatusMessageFlyweight putLongUnaligned(int offset, long value) {
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.putByte(offset + 7, (byte)(value >> 56));
            this.putByte(offset + 6, (byte)(value >> 48));
            this.putByte(offset + 5, (byte)(value >> 40));
            this.putByte(offset + 4, (byte)(value >> 32));
            this.putByte(offset + 3, (byte)(value >> 24));
            this.putByte(offset + 2, (byte)(value >> 16));
            this.putByte(offset + 1, (byte)(value >> 8));
            this.putByte(offset, (byte)value);
        } else {
            this.putByte(offset, (byte)(value >> 56));
            this.putByte(offset + 1, (byte)(value >> 48));
            this.putByte(offset + 2, (byte)(value >> 40));
            this.putByte(offset + 3, (byte)(value >> 32));
            this.putByte(offset + 4, (byte)(value >> 24));
            this.putByte(offset + 5, (byte)(value >> 16));
            this.putByte(offset + 6, (byte)(value >> 8));
            this.putByte(offset + 7, (byte)value);
        }
        return this;
    }

    @Override
    public String toString() {
        return "STATUS{frame-length=" + this.frameLength() + " version=" + this.version() + " flags=" + String.valueOf(StatusMessageFlyweight.flagsToChars(this.flags())) + " type=" + this.headerType() + " session-id=" + this.sessionId() + " stream-id=" + this.streamId() + " consumption-term-id=" + this.consumptionTermId() + " consumption-term-offset=" + this.consumptionTermOffset() + " receiver-window-length=" + this.receiverWindowLength() + "}";
    }
}

