/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Aeron;
import io.aeron.ExclusivePublication;
import io.aeron.Publication;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.samples.SampleConfiguration;
import java.io.File;
import java.nio.ByteOrder;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.IoUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class FileSender {
    private static final int STREAM_ID = SampleConfiguration.STREAM_ID;
    private static final String CHANNEL = SampleConfiguration.CHANNEL;

    public static void main(String[] args) throws InterruptedException {
        if (args.length != 1) {
            System.out.println("Filename to be sent must be supplied as a command line argument");
            System.exit(1);
        }
        try (Aeron aeron = Aeron.connect();
             ExclusivePublication publication = aeron.addExclusivePublication(CHANNEL, STREAM_ID);){
            while (!publication.isConnected()) {
                Thread.sleep(1L);
            }
            File file = new File(args[0]);
            UnsafeBuffer buffer = new UnsafeBuffer(IoUtil.mapExistingFile(file, "sending"));
            long correlationId = aeron.nextCorrelationId();
            FileSender.sendFileCreate(publication, correlationId, buffer.capacity(), file.getName());
            FileSender.streamChunks(publication, correlationId, buffer);
        }
    }

    private static void sendFileCreate(Publication publication, long correlationId, int length, String filename) {
        long result;
        ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
        buffer.putInt(0, 0, ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(4, 1, ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(8, correlationId, ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(16, length, ByteOrder.LITTLE_ENDIAN);
        int msgLength = 24 + buffer.putStringUtf8(24, filename);
        while ((result = publication.offer(buffer, 0, msgLength)) < 0L) {
            FileSender.checkResult(result);
            Thread.yield();
        }
    }

    private static void streamChunks(Publication publication, long correlationId, UnsafeBuffer buffer) {
        int chunkLength;
        BufferClaim bufferClaim = new BufferClaim();
        int fileLength = buffer.capacity();
        int maxChunkLength = publication.maxPayloadLength() - 32;
        for (int chunkOffset = 0; chunkOffset < fileLength; chunkOffset += chunkLength) {
            chunkLength = Math.min(maxChunkLength, fileLength - chunkOffset);
            FileSender.sendChunk(publication, bufferClaim, correlationId, buffer, chunkOffset, chunkLength);
        }
    }

    private static void sendChunk(Publication publication, BufferClaim bufferClaim, long correlationId, UnsafeBuffer fileBuffer, int chunkOffset, int chunkLength) {
        long result;
        while ((result = publication.tryClaim(32 + chunkLength, bufferClaim)) < 0L) {
            FileSender.checkResult(result);
            Thread.yield();
        }
        MutableDirectBuffer buffer = bufferClaim.buffer();
        int offset = bufferClaim.offset();
        buffer.putInt(offset + 0, 0, ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(offset + 4, 2, ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(offset + 8, correlationId, ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(offset + 16, chunkOffset, ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(offset + 24, chunkLength, ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(offset + 32, fileBuffer, chunkOffset, chunkLength);
        bufferClaim.commit();
    }

    private static void checkResult(long result) {
        if (result == -4L) {
            throw new IllegalStateException("Connection has been closed");
        }
        if (result == -1L) {
            throw new IllegalStateException("Connection is no longer available");
        }
        if (result == -5L) {
            throw new IllegalStateException("Publication failed due to max position being reached");
        }
    }
}

