/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.security;

import io.aeron.security.AuthorisationService;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.agrona.collections.BiInt2ObjectMap;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.Object2ObjectHashMap;

public final class SimpleAuthorisationService
implements AuthorisationService {
    private final AuthorisationService defaultAuthorisation;
    private final Object2ObjectHashMap<ByteArrayAsKey, Principal> principalByKeyMap = new Object2ObjectHashMap();
    private final Principal defaultPrincipal;

    private SimpleAuthorisationService(Builder builder) {
        this.defaultAuthorisation = builder.defaultAuthorisation;
        this.principalByKeyMap.putAll(builder.principalByKeyMap);
        this.defaultPrincipal = builder.defaultPrincipal;
    }

    @Override
    public boolean isAuthorised(int protocolId, int actionId, Object type, byte[] encodedPrincipal) {
        Boolean authorised = this.isAuthorised(this.principalByKeyMap.get(new ByteArrayAsKey(encodedPrincipal)), protocolId, actionId, type);
        if (null != authorised) {
            return authorised;
        }
        authorised = this.isAuthorised(this.defaultPrincipal, protocolId, actionId, type);
        if (null != authorised) {
            return authorised;
        }
        return this.defaultAuthorisation.isAuthorised(protocolId, actionId, type, encodedPrincipal);
    }

    private Boolean isAuthorised(Principal principal, int protocolId, int actionId, Object type) {
        if (null == principal) {
            return null;
        }
        return principal.isAuthorised(protocolId, actionId, type);
    }

    private static final class ByteArrayAsKey {
        private final byte[] data;

        private ByteArrayAsKey(byte[] data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteArrayAsKey that = (ByteArrayAsKey)o;
            return Arrays.equals(this.data, that.data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }

    private static final class Principal {
        private final Int2ObjectHashMap<Boolean> byProtocol = new Int2ObjectHashMap();
        private final BiInt2ObjectMap<Boolean> byProtocolAction = new BiInt2ObjectMap();
        private final BiInt2ObjectMap<Set<Object>> byProtocolActionTypeAllowed = new BiInt2ObjectMap();
        private final BiInt2ObjectMap<Set<Object>> byProtocolActionTypeDenied = new BiInt2ObjectMap();
        private final byte[] encodedPrincipal;

        private Principal(byte[] encodedPrincipal) {
            this.encodedPrincipal = encodedPrincipal;
        }

        public Boolean isAuthorised(int protocolId, int actionId, Object type) {
            Set typesAllowed = this.byProtocolActionTypeAllowed.getOrDefault(protocolId, actionId, Collections.emptySet());
            if (typesAllowed.contains(type)) {
                return Boolean.TRUE;
            }
            Set typesDenied = this.byProtocolActionTypeDenied.getOrDefault(protocolId, actionId, Collections.emptySet());
            if (typesDenied.contains(type)) {
                return Boolean.FALSE;
            }
            Boolean authorised = this.byProtocolAction.get(protocolId, actionId);
            if (null != authorised) {
                return authorised;
            }
            return this.byProtocol.get(protocolId);
        }
    }

    public static class Builder {
        private AuthorisationService defaultAuthorisation = AuthorisationService.DENY_ALL;
        private final Object2ObjectHashMap<ByteArrayAsKey, Principal> principalByKeyMap = new Object2ObjectHashMap();
        private final Principal defaultPrincipal = new Principal(new byte[0]);

        public Builder defaultAuthorisation(AuthorisationService defaultAuthorisation) {
            this.defaultAuthorisation = defaultAuthorisation;
            return this;
        }

        public Builder addPrincipalRule(int protocolId, int actionId, Object type, byte[] encodedPrincipal, boolean isAllowed) {
            Principal principal = this.principalByKeyMap.computeIfAbsent(new ByteArrayAsKey(encodedPrincipal), key -> new Principal(((ByteArrayAsKey)key).data));
            BiInt2ObjectMap byTypeMap = isAllowed ? principal.byProtocolActionTypeAllowed : principal.byProtocolActionTypeDenied;
            byTypeMap.computeIfAbsent(protocolId, actionId, (a, b) -> new HashSet()).add(type);
            return this;
        }

        public Builder addPrincipalRule(int protocolId, int actionId, byte[] encodedPrincipal, boolean isAllowed) {
            Principal principal = this.principalByKeyMap.computeIfAbsent(new ByteArrayAsKey(encodedPrincipal), key -> new Principal(((ByteArrayAsKey)key).data));
            principal.byProtocolAction.put(protocolId, actionId, isAllowed);
            return this;
        }

        public Builder addPrincipalRule(int protocolId, byte[] encodedPrincipal, boolean isAllowed) {
            Principal principal = this.principalByKeyMap.computeIfAbsent(new ByteArrayAsKey(encodedPrincipal), key -> new Principal(((ByteArrayAsKey)key).data));
            principal.byProtocol.put(protocolId, Boolean.valueOf(isAllowed));
            return this;
        }

        public Builder addGeneralRule(int protocolId, int actionId, Object type, boolean isAllowed) {
            BiInt2ObjectMap byTypeMap = isAllowed ? this.defaultPrincipal.byProtocolActionTypeAllowed : this.defaultPrincipal.byProtocolActionTypeDenied;
            byTypeMap.computeIfAbsent(protocolId, actionId, (a, b) -> new HashSet()).add(type);
            return this;
        }

        public Builder addGeneralRule(int protocolId, int actionId, boolean isAllowed) {
            this.defaultPrincipal.byProtocolAction.put(protocolId, actionId, isAllowed);
            return this;
        }

        public Builder addGeneralRule(int protocolId, boolean isAllowed) {
            this.defaultPrincipal.byProtocol.put(protocolId, Boolean.valueOf(isAllowed));
            return this;
        }

        public SimpleAuthorisationService newInstance() {
            return new SimpleAuthorisationService(this);
        }
    }
}

