/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.agrona.CloseHelper;
import org.agrona.IoUtil;
import org.agrona.ManagedResource;
import org.agrona.concurrent.UnsafeBuffer;

public class LogBuffers
implements AutoCloseable,
ManagedResource {
    private long timeOfLastStateChangeNs;
    private int refCount;
    private final int termLength;
    private final FileChannel fileChannel;
    private final ByteBuffer[] termBuffers = new ByteBuffer[3];
    private final UnsafeBuffer logMetaDataBuffer;
    private final MappedByteBuffer[] mappedByteBuffers;

    public LogBuffers(String logFileName) {
        try {
            this.fileChannel = FileChannel.open(Paths.get(logFileName, new String[0]), StandardOpenOption.READ, StandardOpenOption.WRITE);
            long logLength = this.fileChannel.size();
            if (logLength < Integer.MAX_VALUE) {
                MappedByteBuffer mappedBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, logLength);
                this.mappedByteBuffers = new MappedByteBuffer[]{mappedBuffer};
                this.logMetaDataBuffer = new UnsafeBuffer((ByteBuffer)mappedBuffer, (int)(logLength - (long)LogBufferDescriptor.LOG_META_DATA_LENGTH), LogBufferDescriptor.LOG_META_DATA_LENGTH);
                int termLength = LogBufferDescriptor.termLength(this.logMetaDataBuffer);
                int pageSize = LogBufferDescriptor.pageSize(this.logMetaDataBuffer);
                LogBufferDescriptor.checkTermLength(termLength);
                LogBufferDescriptor.checkPageSize(pageSize);
                this.termLength = termLength;
                for (int i = 0; i < 3; ++i) {
                    int offset = i * termLength;
                    mappedBuffer.limit(offset + termLength).position(offset);
                    this.termBuffers[i] = mappedBuffer.slice();
                }
            } else {
                MappedByteBuffer metaDataMappedBuffer;
                this.mappedByteBuffers = new MappedByteBuffer[4];
                int assumedTermLength = 0x40000000;
                long metaDataSectionOffset = 0xC0000000L;
                long metaDataMappingLength = logLength - 0xC0000000L;
                this.mappedByteBuffers[this.mappedByteBuffers.length - 1] = metaDataMappedBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0xC0000000L, metaDataMappingLength);
                this.logMetaDataBuffer = new UnsafeBuffer((ByteBuffer)metaDataMappedBuffer, (int)metaDataMappingLength - LogBufferDescriptor.LOG_META_DATA_LENGTH, LogBufferDescriptor.LOG_META_DATA_LENGTH);
                int metaDataTermLength = LogBufferDescriptor.termLength(this.logMetaDataBuffer);
                int pageSize = LogBufferDescriptor.pageSize(this.logMetaDataBuffer);
                LogBufferDescriptor.checkPageSize(pageSize);
                if (metaDataTermLength != 0x40000000) {
                    throw new IllegalStateException("Assumed term length 1073741824 does not match metadata: termLength=" + metaDataTermLength);
                }
                this.termLength = 0x40000000;
                for (int i = 0; i < 3; ++i) {
                    long position = 0x40000000L * (long)i;
                    this.mappedByteBuffers[i] = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, position, 0x40000000L);
                    this.termBuffers[i] = this.mappedByteBuffers[i];
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalStateException ex) {
            this.close();
            throw ex;
        }
    }

    public UnsafeBuffer[] duplicateTermBuffers() {
        UnsafeBuffer[] buffers = new UnsafeBuffer[3];
        for (int i = 0; i < 3; ++i) {
            buffers[i] = new UnsafeBuffer(this.termBuffers[i].duplicate().order(ByteOrder.LITTLE_ENDIAN));
        }
        return buffers;
    }

    public UnsafeBuffer metaDataBuffer() {
        return this.logMetaDataBuffer;
    }

    public FileChannel fileChannel() {
        return this.fileChannel;
    }

    @Override
    public void close() {
        for (MappedByteBuffer buffer : this.mappedByteBuffers) {
            IoUtil.unmap((MappedByteBuffer)buffer);
        }
        CloseHelper.close((AutoCloseable)this.fileChannel);
    }

    public int termLength() {
        return this.termLength;
    }

    public int incRef() {
        return ++this.refCount;
    }

    public int decRef() {
        return --this.refCount;
    }

    public void timeOfLastStateChange(long timeNs) {
        this.timeOfLastStateChangeNs = timeNs;
    }

    public long timeOfLastStateChange() {
        return this.timeOfLastStateChangeNs;
    }

    public void delete() {
        this.close();
    }
}

