/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class LogBufferDescriptor {
    public static final int PARTITION_COUNT = 3;
    public static final int LOG_META_DATA_SECTION_INDEX = 3;
    public static final int TERM_MIN_LENGTH = 65536;
    public static final int TERM_MAX_LENGTH = 0x40000000;
    public static final int PAGE_MIN_SIZE = 4096;
    public static final int PAGE_MAX_SIZE = 0x40000000;
    public static final int TERM_TAIL_COUNTERS_OFFSET;
    public static final int LOG_ACTIVE_TERM_COUNT_OFFSET;
    public static final int LOG_END_OF_STREAM_POSITION_OFFSET;
    public static final int LOG_IS_CONNECTED_OFFSET;
    public static final int LOG_INITIAL_TERM_ID_OFFSET;
    public static final int LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET;
    public static final int LOG_MTU_LENGTH_OFFSET;
    public static final int LOG_CORRELATION_ID_OFFSET;
    public static final int LOG_TERM_LENGTH_OFFSET;
    public static final int LOG_PAGE_SIZE_OFFSET;
    public static final int LOG_DEFAULT_FRAME_HEADER_OFFSET;
    public static final int LOG_DEFAULT_FRAME_HEADER_MAX_LENGTH = 128;
    public static final int LOG_META_DATA_LENGTH;

    public static void checkTermLength(int termLength) {
        if (termLength < 65536) {
            throw new IllegalStateException("Term length less than min length of 65536: length=" + termLength);
        }
        if (termLength > 0x40000000) {
            throw new IllegalStateException("Term length more than max length of 1073741824: length=" + termLength);
        }
        if (!BitUtil.isPowerOfTwo((int)termLength)) {
            throw new IllegalStateException("Term length not a power of 2: length=" + termLength);
        }
    }

    public static void checkPageSize(int pageSize) {
        if (pageSize < 4096) {
            throw new IllegalStateException("Page size less than min size of 4096: page size=" + pageSize);
        }
        if (pageSize > 0x40000000) {
            throw new IllegalStateException("Page size more than max size of 1073741824: page size=" + pageSize);
        }
        if (!BitUtil.isPowerOfTwo((int)pageSize)) {
            throw new IllegalStateException("Page size not a power of 2: page size=" + pageSize);
        }
    }

    public static int initialTermId(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getInt(LOG_INITIAL_TERM_ID_OFFSET);
    }

    public static void initialTermId(UnsafeBuffer logMetaDataBuffer, int initialTermId) {
        logMetaDataBuffer.putInt(LOG_INITIAL_TERM_ID_OFFSET, initialTermId);
    }

    public static int mtuLength(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getInt(LOG_MTU_LENGTH_OFFSET);
    }

    public static void mtuLength(UnsafeBuffer logMetaDataBuffer, int mtuLength) {
        logMetaDataBuffer.putInt(LOG_MTU_LENGTH_OFFSET, mtuLength);
    }

    public static int termLength(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getInt(LOG_TERM_LENGTH_OFFSET);
    }

    public static void termLength(UnsafeBuffer logMetaDataBuffer, int termLength) {
        logMetaDataBuffer.putInt(LOG_TERM_LENGTH_OFFSET, termLength);
    }

    public static int pageSize(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getInt(LOG_PAGE_SIZE_OFFSET);
    }

    public static void pageSize(UnsafeBuffer logMetaDataBuffer, int pageSize) {
        logMetaDataBuffer.putInt(LOG_PAGE_SIZE_OFFSET, pageSize);
    }

    public static long correlationId(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getLong(LOG_CORRELATION_ID_OFFSET);
    }

    public static void correlationId(UnsafeBuffer logMetaDataBuffer, long id) {
        logMetaDataBuffer.putLong(LOG_CORRELATION_ID_OFFSET, id);
    }

    public static boolean isConnected(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getIntVolatile(LOG_IS_CONNECTED_OFFSET) == 1;
    }

    public static void isConnected(UnsafeBuffer logMetaDataBuffer, boolean isConnected) {
        logMetaDataBuffer.putIntOrdered(LOG_IS_CONNECTED_OFFSET, isConnected ? 1 : 0);
    }

    public static long endOfStreamPosition(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getLongVolatile(LOG_END_OF_STREAM_POSITION_OFFSET);
    }

    public static void endOfStreamPosition(UnsafeBuffer logMetaDataBuffer, long position) {
        logMetaDataBuffer.putLongOrdered(LOG_END_OF_STREAM_POSITION_OFFSET, position);
    }

    public static int activeTermCount(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getIntVolatile(LOG_ACTIVE_TERM_COUNT_OFFSET);
    }

    public static void activeTermCountOrdered(UnsafeBuffer logMetaDataBuffer, int termCount) {
        logMetaDataBuffer.putIntOrdered(LOG_ACTIVE_TERM_COUNT_OFFSET, termCount);
    }

    public static boolean casActiveTermCount(UnsafeBuffer logMetaDataBuffer, int expectedTermCount, int updateTermCount) {
        return logMetaDataBuffer.compareAndSetInt(LOG_ACTIVE_TERM_COUNT_OFFSET, expectedTermCount, updateTermCount);
    }

    public static void activeTermCount(UnsafeBuffer logMetaDataBuffer, int termCount) {
        logMetaDataBuffer.putInt(LOG_ACTIVE_TERM_COUNT_OFFSET, termCount);
    }

    public static int nextPartitionIndex(int currentIndex) {
        return (currentIndex + 1) % 3;
    }

    public static int indexByTerm(int initialTermId, int activeTermId) {
        return (activeTermId - initialTermId) % 3;
    }

    public static int indexByTermCount(long termCount) {
        return (int)(termCount % 3L);
    }

    public static int indexByPosition(long position, int positionBitsToShift) {
        return (int)((position >>> positionBitsToShift) % 3L);
    }

    public static long computePosition(int activeTermId, int termOffset, int positionBitsToShift, int initialTermId) {
        long termCount = activeTermId - initialTermId;
        return (termCount << positionBitsToShift) + (long)termOffset;
    }

    public static long computePosition(int termCount, int termOffset, int positionBitsToShift) {
        return (termCount << positionBitsToShift) + termOffset;
    }

    public static long computeTermBeginPosition(int activeTermId, int positionBitsToShift, int initialTermId) {
        long termCount = activeTermId - initialTermId;
        return termCount << positionBitsToShift;
    }

    public static int computeTermIdFromPosition(long position, int positionBitsToShift, int initialTermId) {
        return (int)(position >>> positionBitsToShift) + initialTermId;
    }

    public static int computeTermOffsetFromPosition(long position, int positionBitsToShift) {
        long mask = (1L << positionBitsToShift) - 1L;
        return (int)(position & mask);
    }

    public static long computeLogLength(int termLength, int filePageSize) {
        if (termLength < 0x40000000) {
            return BitUtil.align((int)(termLength * 3 + LOG_META_DATA_LENGTH), (int)filePageSize);
        }
        return 3 * termLength + BitUtil.align((int)LOG_META_DATA_LENGTH, (int)filePageSize);
    }

    public static void storeDefaultFrameHeader(UnsafeBuffer logMetaDataBuffer, DirectBuffer defaultHeader) {
        if (defaultHeader.capacity() != 32) {
            throw new IllegalArgumentException("Default header length not equal to HEADER_LENGTH: length=" + defaultHeader.capacity());
        }
        logMetaDataBuffer.putInt(LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET, 32);
        logMetaDataBuffer.putBytes(LOG_DEFAULT_FRAME_HEADER_OFFSET, defaultHeader, 0, 32);
    }

    public static UnsafeBuffer defaultFrameHeader(UnsafeBuffer logMetaDataBuffer) {
        return new UnsafeBuffer((DirectBuffer)logMetaDataBuffer, LOG_DEFAULT_FRAME_HEADER_OFFSET, 32);
    }

    public static void applyDefaultHeader(UnsafeBuffer logMetaDataBuffer, UnsafeBuffer termBuffer, int termOffset) {
        termBuffer.putBytes(termOffset, (DirectBuffer)logMetaDataBuffer, LOG_DEFAULT_FRAME_HEADER_OFFSET, 32);
    }

    public static boolean rotateLog(UnsafeBuffer logMetaDataBuffer, int currentTermCount, int currentTermId) {
        long rawTail;
        int nextTermId = currentTermId + 1;
        int nextTermCount = currentTermCount + 1;
        int nextIndex = LogBufferDescriptor.indexByTermCount(nextTermCount);
        int expectedTermId = nextTermId - 3;
        while (expectedTermId == LogBufferDescriptor.termId(rawTail = LogBufferDescriptor.rawTail(logMetaDataBuffer, nextIndex)) && !LogBufferDescriptor.casRawTail(logMetaDataBuffer, nextIndex, rawTail, LogBufferDescriptor.packTail(nextTermId, 0))) {
        }
        return LogBufferDescriptor.casActiveTermCount(logMetaDataBuffer, currentTermCount, nextTermCount);
    }

    public static void initialiseTailWithTermId(UnsafeBuffer logMetaData, int partitionIndex, int termId) {
        logMetaData.putLong(TERM_TAIL_COUNTERS_OFFSET + partitionIndex * 8, LogBufferDescriptor.packTail(termId, 0));
    }

    public static int termId(long rawTail) {
        return (int)(rawTail >> 32);
    }

    public static int termOffset(long rawTail, long termLength) {
        long tail = rawTail & 0xFFFFFFFFL;
        return (int)Math.min(tail, termLength);
    }

    public static int termOffset(long result) {
        return (int)result;
    }

    public static long packTail(int termId, int termOffset) {
        return (long)termId << 32 | (long)termOffset & 0xFFFFFFFFL;
    }

    public static void rawTail(UnsafeBuffer logMetaDataBuffer, int partitionIndex, long rawTail) {
        logMetaDataBuffer.putLong(TERM_TAIL_COUNTERS_OFFSET + 8 * partitionIndex, rawTail);
    }

    public static long rawTail(UnsafeBuffer logMetaDataBuffer, int partitionIndex) {
        return logMetaDataBuffer.getLong(TERM_TAIL_COUNTERS_OFFSET + 8 * partitionIndex);
    }

    public static void rawTailVolatile(UnsafeBuffer logMetaDataBuffer, int partitionIndex, long rawTail) {
        logMetaDataBuffer.putLongVolatile(TERM_TAIL_COUNTERS_OFFSET + 8 * partitionIndex, rawTail);
    }

    public static long rawTailVolatile(UnsafeBuffer logMetaDataBuffer, int partitionIndex) {
        return logMetaDataBuffer.getLongVolatile(TERM_TAIL_COUNTERS_OFFSET + 8 * partitionIndex);
    }

    public static long rawTailVolatile(UnsafeBuffer logMetaDataBuffer) {
        int partitionIndex = LogBufferDescriptor.indexByTermCount(LogBufferDescriptor.activeTermCount(logMetaDataBuffer));
        return logMetaDataBuffer.getLongVolatile(TERM_TAIL_COUNTERS_OFFSET + 8 * partitionIndex);
    }

    public static boolean casRawTail(UnsafeBuffer logMetaDataBuffer, int partitionIndex, long expectedRawTail, long updateRawTail) {
        int index = TERM_TAIL_COUNTERS_OFFSET + 8 * partitionIndex;
        return logMetaDataBuffer.compareAndSetLong(index, expectedRawTail, updateRawTail);
    }

    static {
        int offset;
        TERM_TAIL_COUNTERS_OFFSET = offset = 0;
        LOG_ACTIVE_TERM_COUNT_OFFSET = offset += 24;
        LOG_END_OF_STREAM_POSITION_OFFSET = offset = 128;
        LOG_IS_CONNECTED_OFFSET = LOG_END_OF_STREAM_POSITION_OFFSET + 8;
        LOG_CORRELATION_ID_OFFSET = offset += 128;
        LOG_INITIAL_TERM_ID_OFFSET = LOG_CORRELATION_ID_OFFSET + 8;
        LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET = LOG_INITIAL_TERM_ID_OFFSET + 4;
        LOG_MTU_LENGTH_OFFSET = LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET + 4;
        LOG_TERM_LENGTH_OFFSET = LOG_MTU_LENGTH_OFFSET + 4;
        LOG_PAGE_SIZE_OFFSET = LOG_TERM_LENGTH_OFFSET + 4;
        LOG_DEFAULT_FRAME_HEADER_OFFSET = offset += 64;
        LOG_META_DATA_LENGTH = BitUtil.align((int)(offset + 128), (int)4096);
    }
}

