/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.NetworkUtil;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.media.UdpTransportPoller;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class ControlTransportPoller
extends UdpTransportPoller {
    private final ByteBuffer byteBuffer;
    private final UnsafeBuffer unsafeBuffer;
    private final NakFlyweight nakMessage;
    private final StatusMessageFlyweight statusMessage;
    private final RttMeasurementFlyweight rttMeasurement;
    private SendChannelEndpoint[] transports = new SendChannelEndpoint[0];

    public ControlTransportPoller() {
        this.byteBuffer = NetworkUtil.allocateDirectAlignedAndPadded(65504, 128);
        this.unsafeBuffer = new UnsafeBuffer(this.byteBuffer);
        this.nakMessage = new NakFlyweight(this.unsafeBuffer);
        this.statusMessage = new StatusMessageFlyweight(this.unsafeBuffer);
        this.rttMeasurement = new RttMeasurementFlyweight(this.unsafeBuffer);
    }

    public void close() {
        for (SendChannelEndpoint channelEndpoint : this.transports) {
            channelEndpoint.close();
        }
        super.close();
    }

    @Override
    public int pollTransports() {
        int bytesReceived = 0;
        try {
            if (this.transports.length <= 5) {
                for (SendChannelEndpoint transport : this.transports) {
                    bytesReceived += this.poll(transport);
                }
            } else {
                this.selector.selectNow();
                SelectionKey[] keys = this.selectedKeySet.keys();
                int length = this.selectedKeySet.size();
                for (int i = 0; i < length; ++i) {
                    bytesReceived += this.poll((SendChannelEndpoint)keys[i].attachment());
                }
                this.selectedKeySet.reset();
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return bytesReceived;
    }

    @Override
    public SelectionKey registerForRead(UdpChannelTransport transport) {
        return this.registerForRead((SendChannelEndpoint)transport);
    }

    public SelectionKey registerForRead(SendChannelEndpoint transport) {
        SelectionKey key = null;
        try {
            key = transport.receiveDatagramChannel().register(this.selector, 1, transport);
            this.transports = (SendChannelEndpoint[])ArrayUtil.add((Object[])this.transports, (Object)transport);
        }
        catch (ClosedChannelException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return key;
    }

    @Override
    public void cancelRead(UdpChannelTransport transport) {
        this.cancelRead((SendChannelEndpoint)transport);
    }

    public void cancelRead(SendChannelEndpoint transport) {
        this.transports = (SendChannelEndpoint[])ArrayUtil.remove((Object[])this.transports, (Object)transport);
    }

    private int poll(SendChannelEndpoint channelEndpoint) {
        int byteReceived = 0;
        InetSocketAddress srcAddress = channelEndpoint.receive(this.byteBuffer);
        if (null != srcAddress && channelEndpoint.isValidFrame(this.unsafeBuffer, byteReceived = this.byteBuffer.position())) {
            channelEndpoint.receiveHook(this.unsafeBuffer, byteReceived, srcAddress);
            int frameType = FrameDescriptor.frameType((UnsafeBuffer)this.unsafeBuffer, (int)0);
            if (2 == frameType) {
                channelEndpoint.onNakMessage(this.nakMessage, this.unsafeBuffer, byteReceived, srcAddress);
            } else if (3 == frameType) {
                channelEndpoint.onStatusMessage(this.statusMessage, this.unsafeBuffer, byteReceived, srcAddress);
            } else if (6 == frameType) {
                channelEndpoint.onRttMeasurement(this.rttMeasurement, this.unsafeBuffer, byteReceived, srcAddress);
            }
        }
        return byteReceived;
    }
}

