/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import com.google.common.io.CharStreams;
import io.airlift.command.Command;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

class OutputProcessor {
    private final InputStream inputStream;
    private final Executor executor;
    private Future<String> outputFuture;

    public OutputProcessor(Process process, Executor executor) {
        this.inputStream = Objects.requireNonNull(process, "process is null").getInputStream();
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    public void start() {
        this.outputFuture = Command.submit(this.executor, () -> CharStreams.toString((Readable)new InputStreamReader(this.inputStream, StandardCharsets.UTF_8)));
    }

    public String getOutput() {
        if (this.outputFuture != null && !this.outputFuture.isCancelled()) {
            try {
                return this.outputFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return null;
    }

    public void destroy() {
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.outputFuture != null) {
            this.outputFuture.cancel(true);
        }
    }
}

