/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.core.storage;

import io.amient.affinity.core.config.Cfg;
import io.amient.affinity.core.config.CfgStruct;
import io.amient.affinity.core.state.StateConf;
import io.amient.affinity.core.storage.Record;
import io.amient.affinity.core.util.ByteUtils;
import io.amient.affinity.core.util.CloseableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MemStore
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MemStore.class);
    private final boolean checkpointsEnable = this.isPersistent();
    protected final int ttlSecs;
    protected final Path dataDir;

    public MemStore(StateConf conf) throws IOException {
        this.ttlSecs = conf.TtlSeconds.apply();
        if (!this.checkpointsEnable || !this.isPersistent()) {
            this.dataDir = null;
        } else {
            this.dataDir = conf.MemStore.DataDir.apply();
            if (this.dataDir == null) {
                throw new IllegalArgumentException("Could not determine memstore data.dir, you need to either specify node.data.dir or state().memstore.data.dir");
            }
            if (!Files.exists(this.dataDir, new LinkOption[0])) {
                Files.createDirectories(this.dataDir, new FileAttribute[0]);
            }
        }
    }

    public abstract boolean isPersistent();

    public abstract CloseableIterator<Map.Entry<ByteBuffer, ByteBuffer>> iterator(ByteBuffer var1);

    public abstract Optional<ByteBuffer> apply(ByteBuffer var1);

    public abstract long numKeys();

    public abstract void put(ByteBuffer var1, ByteBuffer var2);

    public abstract void remove(ByteBuffer var1);

    public final ByteBuffer wrap(byte[] value, long timestamp) {
        ByteBuffer memStoreValue = ByteBuffer.allocate(8 + value.length);
        memStoreValue.order(ByteOrder.BIG_ENDIAN);
        memStoreValue.putLong(timestamp);
        memStoreValue.put(value);
        memStoreValue.flip();
        return memStoreValue;
    }

    public final Optional<Record<byte[], byte[]>> unwrap(ByteBuffer key, ByteBuffer valueAndMetadata, long ttlMs) {
        long ts = valueAndMetadata.getLong(0);
        if (ttlMs > 0L && valueAndMetadata.getLong(0) + ttlMs < System.currentTimeMillis()) {
            this.remove(key);
            return Optional.empty();
        }
        int len = valueAndMetadata.limit();
        byte[] value = new byte[len - 8];
        valueAndMetadata.position(8);
        valueAndMetadata.get(value);
        return Optional.of(new Record<byte[], byte[]>(ByteUtils.bufToArray(key), value, ts));
    }

    public abstract String getStats();

    public abstract void erase();

    public static class MemStoreConf
    extends CfgStruct<MemStoreConf> {
        public Cfg<Class<? extends MemStore>> Class = this.cls("class", MemStore.class, true).doc("Implementation of storage.MemStore that will be used for lookups");
        public Cfg<Path> DataDir = this.filepath("data.dir", false).doc("Local path where data of this MemStore will be kept - this setting will be derived from the node.data.dir if not set");
        public Cfg<Integer> KeyPrefixSize = this.integer("key.prefix.size", false).doc("Number of head bytes, used for optimized range lookups - this setting will be automatically generated for AvroRecord classes which declare Fixed fields");

        @Override
        protected Set<String> specializations() {
            return new HashSet<String>(Arrays.asList("rocksdb"));
        }
    }
}

