/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.avro.record;

import io.amient.affinity.avro.record.AvroRecord$;
import io.amient.affinity.avro.record.JsonEncoder;
import io.amient.affinity.core.util.ByteUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.Encoder;
import org.apache.avro.util.Utf8;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class AvroJsonConverter$ {
    public static AvroJsonConverter$ MODULE$;
    private final LogicalType UUID_TYPE;
    private final ObjectMapper mapper;

    static {
        new AvroJsonConverter$();
    }

    public LogicalType UUID_TYPE() {
        return this.UUID_TYPE;
    }

    public String toJson(Object data, boolean pretty) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.toJson(out, data, pretty);
        return out.toString();
    }

    public void toJson(OutputStream out, Object data, boolean pretty) {
        this.toJson(out, AvroRecord$.MODULE$.inferSchema(data), data, pretty);
    }

    public void toJson(OutputStream out, Schema schema, Object data, boolean pretty) {
        JsonEncoder encoder = new JsonEncoder(schema, out, pretty);
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        writer.write(AvroRecord$.MODULE$.extract(data, (List<Schema>)new .colon.colon((Object)schema, (List)Nil$.MODULE$)), (Encoder)encoder);
        encoder.flush();
    }

    public boolean toJson$default$2() {
        return false;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public <T> T toAvro(String json, TypeTags.TypeTag<T> evidence$1) {
        return (T)this.toAvro(json, AvroRecord$.MODULE$.inferSchema(evidence$1));
    }

    public Object toAvro(String json, Schema schema) {
        return AvroRecord$.MODULE$.read(this.to$1(this.mapper().readTree(json), schema), schema);
    }

    public static final /* synthetic */ boolean $anonfun$toAvro$5(String utype$1, Schema x$3) {
        String string = x$3.getFullName();
        String string2 = utype$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object to$1(JsonNode json, Schema schema) {
        try {
            GenericData.Record record;
            Object object;
            Schema.Type type;
            Schema.Type type2;
            boolean bl;
            Schema.Type type3;
            boolean bl2;
            Schema.Type type4;
            boolean bl3;
            boolean bl4;
            block28: {
                block29: {
                    boolean bl5 = false;
                    Schema.Type type5 = null;
                    bl4 = false;
                    Schema.Type type6 = null;
                    bl3 = false;
                    type4 = null;
                    bl2 = false;
                    type3 = null;
                    bl = false;
                    type2 = null;
                    type = schema.getType();
                    if (Schema.Type.NULL.equals(type)) {
                        if (json == null) return null;
                        if (json.isNull()) {
                            return null;
                        }
                    }
                    if (Schema.Type.BOOLEAN.equals(type) && json.isBoolean()) {
                        object = BoxesRunTime.boxToBoolean((boolean)json.getBooleanValue());
                        return object;
                    }
                    if (Schema.Type.INT.equals(type) && json.isNumber()) {
                        object = BoxesRunTime.boxToInteger((int)json.getIntValue());
                        return object;
                    }
                    if (Schema.Type.LONG.equals(type) && json.isNumber()) {
                        object = BoxesRunTime.boxToLong((long)json.getLongValue());
                        return object;
                    }
                    if (Schema.Type.FLOAT.equals(type) && json.isNumber()) {
                        object = BoxesRunTime.boxToFloat((float)((float)json.getDoubleValue()));
                        return object;
                    }
                    if (Schema.Type.DOUBLE.equals(type) && json.isNumber()) {
                        object = BoxesRunTime.boxToDouble((double)json.getDoubleValue());
                        return object;
                    }
                    if (Schema.Type.STRING.equals(type)) {
                        bl5 = true;
                        type5 = type;
                        if (json == null) {
                            object = new Utf8();
                            return object;
                        }
                    }
                    if (bl5 && json.isTextual()) {
                        object = new Utf8(json.getTextValue());
                        return object;
                    }
                    if (!Schema.Type.UNION.equals(type)) break block28;
                    bl4 = true;
                    type6 = type;
                    if (schema.getTypes().size() != 2) break block28;
                    Schema.Type type7 = ((Schema)schema.getTypes().get(0)).getType();
                    Schema.Type type8 = Schema.Type.NULL;
                    if (!(type7 == null ? type8 != null : !type7.equals(type8))) break block29;
                    Schema.Type type9 = ((Schema)schema.getTypes().get(1)).getType();
                    Schema.Type type10 = Schema.Type.NULL;
                    if (type9 != null ? !type9.equals(type10) : type10 != null) break block28;
                }
                object = ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getTypes()).asScala()).map((Function1 & Serializable & scala.Serializable)s -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.to$1(json, (Schema)s)), Buffer$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isSuccess())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get()).get();
                return object;
            }
            if (bl4) {
                String utype = (String)json.getFieldNames().next();
                object = ((IterableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getTypes()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AvroJsonConverter$.$anonfun$toAvro$5(utype, x$3)))).map((Function1 & Serializable & scala.Serializable)s -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.to$1(json.get(utype), (Schema)s)), Buffer$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isSuccess())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.get()).get();
                return object;
            }
            if (Schema.Type.ARRAY.equals(type)) {
                bl3 = true;
                type4 = type;
                if (json == null) {
                    object = Collections.emptyList();
                    return object;
                }
            }
            if (bl3 && json.isArray()) {
                LinkedList javaList = new LinkedList();
                ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(json.getElements()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)javaList.add(this.to$1(x, schema.getElementType()))));
                object = javaList;
                return object;
            }
            if (Schema.Type.MAP.equals(type)) {
                bl2 = true;
                type3 = type;
                if (json == null) {
                    object = Collections.emptyMap();
                    return object;
                }
            }
            if (bl2 && json.isObject()) {
                HashMap javaMap = new HashMap();
                ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(json.getFields()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> javaMap.put(new Utf8((String)entry.getKey()), this.to$1((JsonNode)entry.getValue(), schema.getValueType())));
                object = javaMap;
                return object;
            }
            if (Schema.Type.ENUM.equals(type) && json.isTextual()) {
                object = new GenericData.EnumSymbol(schema, json.getTextValue());
                return object;
            }
            if (Schema.Type.BYTES.equals(type)) {
                object = ByteBuffer.wrap(json.getTextValue().getBytes(StandardCharsets.UTF_8));
                return object;
            }
            if (Schema.Type.FIXED.equals(type)) {
                bl = true;
                type2 = type;
                LogicalType logicalType = schema.getLogicalType();
                LogicalType logicalType2 = this.UUID_TYPE();
                if (!(logicalType != null ? !logicalType.equals(logicalType2) : logicalType2 != null)) {
                    object = new GenericData.Fixed(schema, ByteUtils.parseUUID((String)json.getTextValue()));
                    return object;
                }
            }
            if (bl) {
                object = new GenericData.Fixed(schema, json.getTextValue().getBytes(StandardCharsets.UTF_8));
                return object;
            }
            if (!Schema.Type.RECORD.equals(type)) throw new IllegalArgumentException(new StringBuilder(26).append("Unsupported schema type `").append(type).append("`").toString());
            if (!json.isObject()) throw new IllegalArgumentException(new StringBuilder(26).append("Unsupported schema type `").append(type).append("`").toString());
            GenericRecordBuilder builder = new GenericRecordBuilder(schema);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).foreach((Function1 & Serializable & scala.Serializable)field -> {
                BoxedUnit boxedUnit;
                try {
                    if (json.has(field.name())) {
                        JsonNode d = json.get(field.name());
                        boxedUnit = builder.set(field, this.to$1(d, field.schema()));
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException(new StringBuilder(54).append("Can't convert json field `").append(field).append("` with value ").append(json.get(field.name())).append(" using schema: ").append(field.schema()).toString(), e);
                }
                return boxedUnit;
            });
            try {
                record = builder.build();
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(new StringBuilder(16).append("Could not build ").append(schema).toString(), e);
            }
            object = record;
            return object;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Can't convert ").append(json).append(" using schema: ").append(schema).toString(), e);
        }
    }

    private AvroJsonConverter$() {
        MODULE$ = this;
        this.UUID_TYPE = LogicalTypes.uuid();
        this.mapper = new ObjectMapper();
    }
}

