/*
 * Copyright 2019 Red Hat
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.apicurio.datamodels.core.validation.rules.invalid.value;

import io.apicurio.datamodels.core.Constants;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;

/**
 * Implements the Invalid API Scheme rule.
 * @author eric.wittmann@gmail.com
 */
public class OasInvalidApiSchemeRule extends OasInvalidPropertyValueRule {
    
    /**
     * Constructor.
     * @param ruleInfo
     */
    public OasInvalidApiSchemeRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }
    
    /**
     * @see io.apicurio.datamodels.combined.visitors.CombinedAllNodeVisitor#visitDocument(io.apicurio.datamodels.core.models.Document)
     */
    @Override
    public void visitDocument(Document node) {
        Oas20Document doc = (Oas20Document) node;
        if (hasValue(doc.schemes)) {
            doc.schemes.forEach(scheme -> {
                this.reportIfInvalid(isValidEnumItem(scheme, array("http", "https", "ws", "wss")), node, 
                        Constants.PROP_SCHEMES, map("scheme", scheme));
            });
        }
    }

}
