/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.asyncapi.models;

import io.apicurio.datamodels.asyncapi.models.AaiSecurityRequirement;
import io.apicurio.datamodels.asyncapi.models.AaiServerBindings;
import io.apicurio.datamodels.asyncapi.visitors.IAaiVisitor;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.INamed;
import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.core.visitors.IVisitor;
import java.util.ArrayList;
import java.util.List;

public abstract class AaiServer
extends Server
implements INamed {
    public String _name;
    public String protocol;
    public String protocolVersion;
    public List<AaiSecurityRequirement> security;
    public AaiServerBindings bindings;

    public AaiServer(String name) {
        this._name = name;
    }

    public AaiServer(Node parent) {
        if (parent != null) {
            this._parent = parent;
            this._ownerDocument = parent.ownerDocument();
        }
    }

    public AaiServer(Node parent, String name) {
        this(parent);
        this._name = name;
    }

    @Override
    public void accept(IVisitor visitor) {
        IAaiVisitor viz = (IAaiVisitor)visitor;
        viz.visitServer(this);
    }

    public abstract AaiSecurityRequirement createSecurityRequirement();

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void rename(String newName) {
        this._name = newName;
    }

    public AaiSecurityRequirement addSecurityRequirement(AaiSecurityRequirement securityRequirement) {
        if (this.security == null) {
            this.security = new ArrayList<AaiSecurityRequirement>();
        }
        this.security.add(securityRequirement);
        return securityRequirement;
    }
}

