/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasPathItem;

public class AddPathItemCommand
extends AbstractCommand {
    public boolean _pathItemExists;
    public String _newPathItemName;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _newPathItemObj;
    public boolean _nullPathItems;

    AddPathItemCommand() {
    }

    AddPathItemCommand(String pathItemName) {
        this._newPathItemName = pathItemName;
    }

    AddPathItemCommand(String pathItemName, Object from) {
        this._newPathItemName = pathItemName;
        this._newPathItemObj = from;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[AddPathItemCommand] Executing.", new Object[0]);
        OasDocument doc = (OasDocument)document;
        if (this.isNullOrUndefined(doc.paths)) {
            doc.paths = doc.createPaths();
            this._nullPathItems = true;
        }
        if (!this.isNullOrUndefined(doc.paths.getPathItem(this._newPathItemName))) {
            LoggerCompat.info("[AddPathItemCommand] PathItem with name %s already exists.", this._newPathItemName);
            this._pathItemExists = true;
        } else {
            OasPathItem pathItem = doc.paths.createPathItem(this._newPathItemName);
            Library.readNode(this._newPathItemObj, pathItem);
            doc.paths.addPathItem(this._newPathItemName, pathItem);
            this._pathItemExists = false;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[AddPathItemCommand] Reverting.", new Object[0]);
        if (this._pathItemExists) {
            return;
        }
        OasDocument doc = (OasDocument)document;
        if (this._nullPathItems) {
            doc.paths = null;
        } else {
            doc.paths.removePathItem(this._newPathItemName);
        }
    }
}

