/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;

public class ChangeLicenseCommand
extends AbstractCommand {
    public String _newLicenseName;
    public String _newLicenseUrl;
    public Object _oldLicense;
    public boolean _nullInfo;

    ChangeLicenseCommand() {
    }

    ChangeLicenseCommand(String name, String url) {
        this._newLicenseName = name;
        this._newLicenseUrl = url;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangeLicenseCommand] Executing.", new Object[0]);
        this._oldLicense = null;
        this._nullInfo = false;
        if (this.isNullOrUndefined(document.info)) {
            this._nullInfo = true;
            document.info = document.createInfo();
            this._oldLicense = null;
        } else {
            this._oldLicense = null;
            if (!this.isNullOrUndefined(document.info.license)) {
                this._oldLicense = Library.writeNode(document.info.license);
            }
        }
        document.info.license = document.info.createLicense();
        document.info.license.name = this._newLicenseName;
        document.info.license.url = this._newLicenseUrl;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangeLicenseCommand] Reverting.", new Object[0]);
        if (this._nullInfo) {
            document.info = null;
        } else if (ModelUtils.isDefined(this._oldLicense)) {
            document.info.license = document.info.createLicense();
            Library.readNode(this._oldLicense, document.info.license);
        } else {
            document.info.license = null;
        }
    }
}

