/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.models.SimplifiedType;
import io.apicurio.datamodels.cmd.util.SimplifiedTypeUtil;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;

public class ChangeMediaTypeTypeCommand
extends AbstractCommand {
    public NodePath _mediaTypePath;
    public String _mediaTypeName;
    public SimplifiedType _newType;
    public boolean _changed;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldMediaTypeSchema;

    ChangeMediaTypeTypeCommand() {
    }

    ChangeMediaTypeTypeCommand(Oas30MediaType mediaType, SimplifiedType newType) {
        this._mediaTypeName = mediaType.getName();
        this._mediaTypePath = Library.createNodePath(mediaType);
        this._newType = newType;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangeMediaTypeTypeCommand] Executing.", new Object[0]);
        this._changed = false;
        Oas30MediaType mediaType = (Oas30MediaType)this._mediaTypePath.resolve(document);
        if (this.isNullOrUndefined(mediaType)) {
            return;
        }
        if (this.isNullOrUndefined(mediaType.schema)) {
            this._oldMediaTypeSchema = null;
            mediaType.schema = mediaType.createSchema();
        } else {
            this._oldMediaTypeSchema = Library.writeNode(mediaType.schema);
        }
        SimplifiedTypeUtil.setSimplifiedType(mediaType.schema, this._newType);
        this._changed = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangeMediaTypeTypeCommand] Reverting.", new Object[0]);
        if (!this._changed) {
            return;
        }
        Oas30MediaType mediaType = (Oas30MediaType)this._mediaTypePath.resolve(document);
        if (this.isNullOrUndefined(mediaType)) {
            return;
        }
        if (this.isNullOrUndefined(this._oldMediaTypeSchema)) {
            mediaType.schema = null;
        } else {
            mediaType.schema = mediaType.createSchema();
            Library.readNode(this._oldMediaTypeSchema, mediaType.schema);
        }
    }
}

