/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.ISecurityRequirementParent;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.openapi.models.OasSecurityRequirement;
import java.util.ArrayList;
import java.util.List;

public class DeleteAllSecurityRequirementsCommand
extends AbstractCommand {
    public NodePath _parentPath;
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public List<Object> _oldSecurityRequirements;

    DeleteAllSecurityRequirementsCommand() {
    }

    DeleteAllSecurityRequirementsCommand(ISecurityRequirementParent parent) {
        Library.createNodePath((Node)((Object)parent));
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteAllSecurityRequirementsCommand] Executing.", new Object[0]);
        this._oldSecurityRequirements = new ArrayList<Object>();
        ISecurityRequirementParent parent = (ISecurityRequirementParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        List<SecurityRequirement> requirements = parent.getSecurityRequirements();
        if (!this.isNullOrUndefined(requirements)) {
            requirements.forEach(req -> this._oldSecurityRequirements.add(Library.writeNode(req)));
        }
        NodeCompat.setProperty(parent, "security", null);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteAllSecurityRequirementsCommand] Reverting.", new Object[0]);
        if (ModelUtils.isDefined(this._oldSecurityRequirements) && this._oldSecurityRequirements.size() == 0) {
            return;
        }
        ISecurityRequirementParent parent = (ISecurityRequirementParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        List<SecurityRequirement> requirements = parent.getSecurityRequirements();
        if (this.isNullOrUndefined(requirements)) {
            requirements = new ArrayList<SecurityRequirement>();
            NodeCompat.setProperty(parent, "security", requirements);
        }
        for (Object oldSecurityRequirement : this._oldSecurityRequirements) {
            OasSecurityRequirement requirement = (OasSecurityRequirement)parent.createSecurityRequirement();
            Library.readNode(oldSecurityRequirement, requirement);
            requirements.add(requirement);
        }
    }
}

