/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.v2.models.Oas20Response;

public class DeleteExampleCommand_20
extends AbstractCommand {
    public String _exampleContentType;
    public NodePath _responsePath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldExample;

    DeleteExampleCommand_20() {
    }

    DeleteExampleCommand_20(Oas20Response response, String contentType) {
        this._responsePath = Library.createNodePath(response);
        this._exampleContentType = contentType;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteExampleCommand] Executing.", new Object[0]);
        this._oldExample = null;
        Oas20Response response = (Oas20Response)this._responsePath.resolve(document);
        if (this.isNullOrUndefined(response) || this.isNullOrUndefined(response.examples) || this.isNullOrUndefined(response.examples.getExample(this._exampleContentType))) {
            LoggerCompat.debug("[DeleteExampleCommand] No example with content-type: " + this._exampleContentType, new Object[0]);
            return;
        }
        this._oldExample = response.examples.removeExample(this._exampleContentType);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteExampleCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldExample)) {
            return;
        }
        Oas20Response response = (Oas20Response)this._responsePath.resolve(document);
        if (this.isNullOrUndefined(response)) {
            return;
        }
        if (this.isNullOrUndefined(response.examples)) {
            response.examples = response.createExample();
        }
        response.examples.addExample(this._exampleContentType, this._oldExample);
    }
}

