/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.compat;

import java.io.PrintStream;

public class LoggerCompat {
    private static void output(String prefix, PrintStream stream, String message, Object ... args) {
        stream.print("|");
        stream.print(prefix);
        stream.print("| ");
        stream.print(LoggerCompat.formatMessage(message, args));
        stream.println("");
    }

    private static String formatMessage(String message, Object[] args) {
        int idx;
        boolean done = false;
        String rval = message;
        int argidx = 0;
        while (!done && (idx = rval.indexOf("%")) != -1) {
            rval = rval.substring(0, idx) + String.valueOf(args[argidx++]) + rval.substring(idx + 2);
        }
        return rval;
    }

    public static void info(String message, Object ... args) {
        LoggerCompat.output("INFO", System.out, message, args);
    }

    public static void warn(String message, Object ... args) {
        LoggerCompat.output("WARN", System.err, message, args);
    }

    public static void debug(String message, Object ... args) {
        LoggerCompat.output("DEBUG", System.out, message, args);
    }
}

