/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation;

import io.apicurio.datamodels.combined.visitors.CombinedAllNodeVisitor;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.compat.RegexCompat;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.validation.IValidationProblemReporter;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.core.visitors.IVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ValidationRule
extends CombinedAllNodeVisitor
implements IVisitor {
    private static List<String> HTTP_STATUS_CODES;
    private static String PATH_MATCH_REGEX;
    private static String SEG_MATCH_REGEX;
    private static String URL_MATCH_REGEX;
    private static String EMAIL_MATCH_REGEX;
    private static String MIME_TYPE_MATCH_REGEX;
    private IValidationProblemReporter reporter;
    private ValidationRuleMetaData ruleInfo;

    public ValidationRule(ValidationRuleMetaData ruleInfo) {
        HTTP_STATUS_CODES = new ArrayList<String>(Arrays.asList("100", "101", "102", "1XX", "10X", "200", "201", "202", "203", "204", "205", "206", "207", "208", "226", "2XX", "20X", "21X", "22X", "300", "301", "302", "303", "304", "305", "306", "307", "308", "3XX", "30X", "400", "401", "402", "403", "404", "405", "406", "407", "408", "409", "410", "411", "412", "413", "414", "415", "416", "417", "4XX", "40X", "41X", "421", "422", "423", "424", "426", "427", "428", "429", "431", "451", "42X", "43X", "44X", "45X", "500", "501", "502", "503", "504", "505", "506", "507", "508", "510", "511", "5XX", "50X", "51X"));
        this.ruleInfo = ruleInfo;
    }

    public void setReporter(IValidationProblemReporter reporter) {
        this.reporter = reporter;
    }

    protected void report(Node node, String property, Map<String, String> messageParams) {
        String messageTemplate = this.ruleInfo.messageTemplate;
        String message = this.resolveMessage(messageTemplate, messageParams);
        this.reporter.report(this.ruleInfo, node, property, message);
    }

    private String resolveMessage(String messageTemplate, Map<String, String> messageParams) {
        if (messageParams == null || messageParams.size() == 0) {
            return messageTemplate;
        }
        List<String[]> matches = RegexCompat.findMatches(messageTemplate, "\\$\\{\\s*'\\s*([a-zA-Z0-9]+)\\s*'\\s*\\}");
        if (matches.size() == 0) {
            return messageTemplate;
        }
        String rval = messageTemplate;
        for (String[] match : matches) {
            String mval = match[0];
            String paramName = match[1];
            String paramValue = messageParams.get(paramName);
            int start = rval.indexOf(mval);
            int end = start + mval.length();
            rval = rval.substring(0, start) + paramValue + rval.substring(end);
        }
        return rval;
    }

    protected void reportIfInvalid(boolean isValid, Node node, String property, Map<String, String> messageParams) {
        if (!isValid) {
            this.report(node, property, messageParams);
        }
    }

    protected void reportIf(boolean condition, Node node, String property, Map<String, String> messageParams) {
        if (condition) {
            this.report(node, property, messageParams);
        }
    }

    protected void reportPathError(Node node, Map<String, String> messageParams) {
        this.report(node, null, messageParams);
    }

    protected boolean isDefined(Object propertyValue) {
        return !NodeCompat.isNullOrUndefined(propertyValue);
    }

    protected boolean hasValue(Object propertyValue) {
        return this.isDefined(propertyValue);
    }

    protected boolean isPathWellFormed(String pathTemplate) {
        return RegexCompat.matches(pathTemplate, PATH_MATCH_REGEX);
    }

    protected List<PathSegment> getPathSegments(String pathTemplate) {
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        if (pathTemplate == null || "".equals(pathTemplate)) {
            return pathSegments;
        }
        String normalizedPath = pathTemplate;
        if (pathTemplate.lastIndexOf("/") == pathTemplate.length() - 1) {
            normalizedPath = pathTemplate.substring(0, pathTemplate.length() - 1);
        }
        int segId = 0;
        List<String[]> matches = RegexCompat.findMatches(normalizedPath, SEG_MATCH_REGEX);
        for (String[] mi : matches) {
            PathSegment pathSegment = new PathSegment();
            pathSegment.segId = segId;
            pathSegment.prefix = mi[1];
            String fn = mi[3];
            if (fn != null && !fn.trim().isEmpty()) {
                pathSegment.formalName = fn;
                pathSegment.normalizedName = "__param__" + segId;
            }
            pathSegments.add(pathSegment);
            ++segId;
        }
        return pathSegments;
    }

    protected boolean isNullOrUndefined(Object value) {
        return NodeCompat.isNullOrUndefined(value);
    }

    protected boolean isValidUrl(String propertyValue) {
        return propertyValue.length() < 2083 && RegexCompat.matches(propertyValue, URL_MATCH_REGEX);
    }

    protected boolean isValidUrlTemplate(String propertyValue) {
        return true;
    }

    protected boolean isValidGFM(String propertyValue) {
        return true;
    }

    protected boolean isValidCommonMark(String propertyValue) {
        return true;
    }

    protected boolean isValidEmailAddress(String propertyValue) {
        return RegexCompat.matches(propertyValue, EMAIL_MATCH_REGEX);
    }

    protected boolean isValidMimeType(List<String> propertyValue) {
        for (String v : propertyValue) {
            if (RegexCompat.matches(v, MIME_TYPE_MATCH_REGEX)) continue;
            return false;
        }
        return true;
    }

    protected boolean isValidEnumItem(String value, String[] items) {
        for (String item : items) {
            if (item == null || !item.equals(value)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidForType(Object value, Node node) {
        return true;
    }

    protected boolean isValidHttpCode(String statusCode) {
        return HTTP_STATUS_CODES.indexOf(statusCode) != -1;
    }

    protected Map<String, String> map(String ... args) {
        if (args == null || args.length < 2) {
            return null;
        }
        HashMap<String, String> rval = new HashMap<String, String>();
        for (int idx = 0; idx < args.length; idx += 2) {
            String key = args[idx].toString();
            String value = args[idx + 1];
            rval.put(key, value);
        }
        return rval;
    }

    protected String[] array(String ... args) {
        return args;
    }

    protected boolean equals(Object value1, Object value2) {
        return NodeCompat.equals(value1, value2);
    }

    static {
        PATH_MATCH_REGEX = "^(\\/[^{}\\/]*(\\{[a-zA-Z_][0-9a-zA-Z_]*\\})?)+$";
        SEG_MATCH_REGEX = "\\/([^{}\\/]*)(\\{([a-zA-Z_][0-9a-zA-Z_]*)\\})?";
        URL_MATCH_REGEX = "^(?!mailto:)(?:(?:http|https|ftp)://)(?:\\S+(?::\\S*)?@)?(?:(?:(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[0-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z\\u00a1-\\uffff0-9]+-?)*[a-z\\u00a1-\\uffff0-9]+)(?:\\.(?:[a-z\\u00a1-\\uffff0-9]+-?)*[a-z\\u00a1-\\uffff0-9]+)*(?:\\.(?:[a-z\\u00a1-\\uffff]{2,})))|localhost)(?::\\d{2,5})?(?:(/|\\?|#)[^\\s]*)?$";
        EMAIL_MATCH_REGEX = "^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$";
        MIME_TYPE_MATCH_REGEX = "^.*\\/.*(;.*)?$";
    }

    public static class PathSegment {
        public int segId;
        public String prefix;
        public String formalName;
        public String normalizedName;
    }
}

